/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.AbstractPedanticDependencyOrderEnforcer;
import com.github.ferstl.maven.pomenforcers.ErrorReport;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerRule;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerVisitor;
import com.github.ferstl.maven.pomenforcers.model.DependencyModel;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;

@Named(value="dependencyManagementOrder")
public class PedanticDependencyManagementOrderEnforcer
extends AbstractPedanticDependencyOrderEnforcer {
    @Inject
    public PedanticDependencyManagementOrderEnforcer(MavenProject project, ExpressionEvaluator helper) {
        super(project, helper);
    }

    @Override
    protected PedanticEnforcerRule getDescription() {
        return PedanticEnforcerRule.DEPENDENCY_MANAGEMENT_ORDER;
    }

    @Override
    protected void accept(PedanticEnforcerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected Collection<DependencyModel> getDeclaredDependencies() {
        return this.getProjectModel().getManagedDependencies();
    }

    @Override
    protected Collection<Dependency> getMavenDependencies(MavenProject project) {
        DependencyManagement dependencyManagement = project.getDependencyManagement();
        if (dependencyManagement != null) {
            return dependencyManagement.getDependencies();
        }
        return Collections.emptyList();
    }

    @Override
    protected void reportError(ErrorReport report, Collection<DependencyModel> resolvedDependencies, Collection<DependencyModel> sortedDependencies) {
        report.addLine("Your dependency management has to be ordered this way:").emptyLine().addDiffUsingToString(resolvedDependencies, sortedDependencies, "Actual Order", "Required Order");
    }
}

