/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.AbstractPedanticDependencyOrderEnforcer;
import com.github.ferstl.maven.pomenforcers.ErrorReport;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerRule;
import com.github.ferstl.maven.pomenforcers.PedanticEnforcerVisitor;
import com.github.ferstl.maven.pomenforcers.model.DependencyModel;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;

@Named(value="dependencyOrder")
public class PedanticDependencyOrderEnforcer
extends AbstractPedanticDependencyOrderEnforcer {
    @Inject
    public PedanticDependencyOrderEnforcer(MavenProject project, ExpressionEvaluator helper) {
        super(project, helper);
    }

    @Override
    protected void accept(PedanticEnforcerVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected PedanticEnforcerRule getDescription() {
        return PedanticEnforcerRule.DEPENDENCY_ORDER;
    }

    @Override
    protected Collection<DependencyModel> getDeclaredDependencies() {
        return this.getProjectModel().getDependencies();
    }

    @Override
    protected Collection<Dependency> getMavenDependencies(MavenProject project) {
        return project.getDependencies();
    }

    @Override
    protected void reportError(ErrorReport report, Collection<DependencyModel> resolvedDependencies, Collection<DependencyModel> sortedDependencies) {
        report.addLine("Your dependencies have to be sorted this way:").emptyLine().addDiffUsingToString(resolvedDependencies, sortedDependencies, "Actual Order", "Required Order");
    }
}

