/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers;

import com.github.ferstl.maven.pomenforcers.AbstractPedanticEnforcer;
import com.github.ferstl.maven.pomenforcers.CompoundPedanticEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticDependencyConfigurationEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticDependencyElementEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticDependencyManagementLocationEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticDependencyManagementOrderEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticDependencyOrderEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticDependencyScopeEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticModuleOrderEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticPluginConfigurationEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticPluginElementEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticPluginManagementLocationEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticPluginManagementOrderEnforcer;
import com.github.ferstl.maven.pomenforcers.PedanticPomSectionOrderEnforcer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;

public enum PedanticEnforcerRule {
    COMPOUND("One does not simply write a POM file!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule(MavenProject project, ExpressionEvaluator helper) {
            throw new UnsupportedOperationException("The " + CompoundPedanticEnforcer.class.getSimpleName() + " is not supposed to be instantiated outside the maven-enforcer-plugin.");
        }
    }
    ,
    POM_SECTION_ORDER("One does not simply write a POM file!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule(MavenProject project, ExpressionEvaluator helper) {
            return new PedanticPomSectionOrderEnforcer(project, helper);
        }
    }
    ,
    MODULE_ORDER("One does not simply declare modules!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule(MavenProject project, ExpressionEvaluator helper) {
            return new PedanticModuleOrderEnforcer(project, helper);
        }
    }
    ,
    DEPENDENCY_MANAGEMENT_ORDER("One does not simply declare dependency management!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule(MavenProject project, ExpressionEvaluator helper) {
            return new PedanticDependencyManagementOrderEnforcer(project, helper);
        }
    }
    ,
    DEPENDENCY_MANAGEMENT_LOCATION("One does not simply declare dependency management!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule(MavenProject project, ExpressionEvaluator helper) {
            return new PedanticDependencyManagementLocationEnforcer(project, helper);
        }
    }
    ,
    DEPENDENCY_ORDER("One does not simply declare dependencies!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule(MavenProject project, ExpressionEvaluator helper) {
            return new PedanticDependencyOrderEnforcer(project, helper);
        }
    }
    ,
    DEPENDENCY_CONFIGURATION("One does not simply configure dependencies!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule(MavenProject project, ExpressionEvaluator helper) {
            return new PedanticDependencyConfigurationEnforcer(project, helper);
        }
    }
    ,
    DEPENDENCY_ELEMENT("One does not simply declare a dependency!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule(MavenProject project, ExpressionEvaluator helper) {
            return new PedanticDependencyElementEnforcer(project, helper);
        }
    }
    ,
    DEPENDENCY_SCOPE("One does not simply declare dependency scopes!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule(MavenProject project, ExpressionEvaluator helper) {
            return new PedanticDependencyScopeEnforcer(project, helper);
        }
    }
    ,
    PLUGIN_MANAGEMENT_ORDER("One does not simply declare plugin management!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule(MavenProject project, ExpressionEvaluator helper) {
            return new PedanticPluginManagementOrderEnforcer(project, helper);
        }
    }
    ,
    PLUGIN_CONFIGURATION("One does not simply configure plugins!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule(MavenProject project, ExpressionEvaluator helper) {
            return new PedanticPluginConfigurationEnforcer(project, helper);
        }
    }
    ,
    PLUGIN_ELEMENT("One does not simple declare a plugin!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule(MavenProject project, ExpressionEvaluator helper) {
            return new PedanticPluginElementEnforcer(project, helper);
        }
    }
    ,
    PLUGIN_MANAGEMENT_LOCATION("One does not simply declare plugin management!"){

        @Override
        public AbstractPedanticEnforcer createEnforcerRule(MavenProject project, ExpressionEvaluator helper) {
            return new PedanticPluginManagementLocationEnforcer(project, helper);
        }
    };

    private final String slogan;

    private PedanticEnforcerRule(String slogan) {
        this.slogan = slogan;
    }

    public String getSlogan() {
        return this.slogan;
    }

    public abstract AbstractPedanticEnforcer createEnforcerRule(MavenProject var1, ExpressionEvaluator var2);
}

