/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers.model;

import com.google.common.base.Joiner;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;

public class ArtifactModel {
    private static final Joiner TO_STRING_JOINER = Joiner.on((String)":").useForNull("");
    private static final String WILDCARD = "*";
    private static final char WILDCARD_CHAR = "*".charAt(0);
    @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
    private String groupId;
    @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
    private String artifactId;
    @XmlElement(namespace="http://maven.apache.org/POM/4.0.0")
    private String version;

    ArtifactModel() {
    }

    public ArtifactModel(String groupId, String artifactId, String version) {
        ArtifactModel.determineWildcardMode(groupId);
        ArtifactModel.determineWildcardMode(artifactId);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public ArtifactModel(String groupId, String artifactId) {
        this(groupId, artifactId, null);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean matches(ArtifactModel pattern) {
        if (pattern == this) {
            return true;
        }
        if (pattern == null) {
            return false;
        }
        return ArtifactModel.match(this.groupId, pattern.groupId) && ArtifactModel.match(this.artifactId, pattern.artifactId);
    }

    public String toString() {
        return TO_STRING_JOINER.join((Object)this.groupId, (Object)this.artifactId, new Object[]{this.version});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArtifactModel)) {
            return false;
        }
        ArtifactModel other = (ArtifactModel)obj;
        return com.google.common.base.Objects.equal((Object)this.groupId, (Object)other.groupId) && com.google.common.base.Objects.equal((Object)this.artifactId, (Object)other.artifactId);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId);
    }

    private static WildcardMode determineWildcardMode(String string) {
        if (string == null) {
            return WildcardMode.NONE;
        }
        int wildcardCount = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != WILDCARD_CHAR) continue;
            ++wildcardCount;
        }
        if (wildcardCount == 0) {
            return WildcardMode.NONE;
        }
        if (wildcardCount == 1 && string.length() == 1) {
            return WildcardMode.FULL;
        }
        if (wildcardCount == 1 && string.startsWith(WILDCARD)) {
            return WildcardMode.LEADING;
        }
        if (wildcardCount == 1 && string.endsWith(WILDCARD)) {
            return WildcardMode.TRAILING;
        }
        if (wildcardCount == 2 && string.startsWith(WILDCARD) && string.endsWith(WILDCARD)) {
            return WildcardMode.CONTAINS;
        }
        throw new IllegalArgumentException("Invalid wildcard pattern '" + string + "'");
    }

    private static boolean match(String string, String pattern) {
        switch (ArtifactModel.determineWildcardMode(pattern).ordinal()) {
            case 0: {
                return string.equals(pattern);
            }
            case 1: {
                return string.endsWith(pattern.substring(1));
            }
            case 2: {
                return string.startsWith(pattern.substring(0, pattern.length() - 1));
            }
            case 3: {
                return string.contains(pattern.substring(1, pattern.length() - 1));
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    private static enum WildcardMode {
        NONE,
        LEADING,
        TRAILING,
        CONTAINS,
        FULL;

    }
}

