/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.maven.pomenforcers.model.functions;

import com.github.ferstl.maven.pomenforcers.model.PluginModel;
import com.github.ferstl.maven.pomenforcers.model.functions.AbstractOneToOneMatcher;
import com.github.ferstl.maven.pomenforcers.util.EnforcerRuleUtils;
import com.google.common.base.Strings;
import java.util.Objects;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;

public class PluginMatcher
extends AbstractOneToOneMatcher<Plugin, PluginModel> {
    private static final String DEFAULT_GROUP_ID = "org.apache.maven.plugins";

    public PluginMatcher(ExpressionEvaluator helper) {
        super(helper);
    }

    @Override
    protected PluginModel transform(Plugin mavenPlugin) {
        return new PluginModel(mavenPlugin.getGroupId(), mavenPlugin.getArtifactId(), mavenPlugin.getVersion());
    }

    @Override
    protected boolean matches(PluginModel supersetItem, PluginModel subsetItem) {
        String groupId = this.getGroupId(subsetItem);
        String artifactId = EnforcerRuleUtils.evaluateProperties(subsetItem.getArtifactId(), this.getHelper());
        return Objects.equals(supersetItem.getGroupId(), groupId) && Objects.equals(supersetItem.getArtifactId(), artifactId);
    }

    private String getGroupId(PluginModel plugin) {
        String groupId = EnforcerRuleUtils.evaluateProperties(plugin.getGroupId(), this.getHelper());
        return !Strings.isNullOrEmpty((String)groupId) ? groupId : DEFAULT_GROUP_ID;
    }
}

