/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.compiler;

import com.github.fge.compiler.CompilingException;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.UUID;

public final class CompilerOutputDirectory {
    private static final String CANNOT_CREATE_DIRECTORY = "cannot create base directory";
    private static final String CANNOT_CREATE_URI = "cannot create URI from base directory";
    private static final String CANNOT_FIND_CLASS = "cannot find class even though compilation succeeded??";
    private final File baseDir;
    private final URLClassLoader classLoader;
    private final String fullClassName;

    public CompilerOutputDirectory(String fullClassName) throws CompilingException {
        URL url;
        this.fullClassName = fullClassName;
        String tmpdir = System.getProperty("java.io.tmpdir", "/tmp");
        String uuid = UUID.randomUUID().toString();
        this.baseDir = new File(tmpdir + '/' + uuid);
        if (!this.baseDir.mkdirs()) {
            throw new CompilingException(CANNOT_CREATE_DIRECTORY);
        }
        try {
            url = this.baseDir.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new CompilingException(new ProcessingMessage().setMessage(CANNOT_CREATE_URI), e);
        }
        this.classLoader = URLClassLoader.newInstance(new URL[]{url});
    }

    public String getDirectory() {
        return this.baseDir.toString();
    }

    public Class<?> getGeneratedClass() throws CompilingException {
        try {
            return this.classLoader.loadClass(this.fullClassName);
        }
        catch (ClassNotFoundException e) {
            throw new CompilingException(new ProcessingMessage().setMessage(CANNOT_FIND_CLASS).put("class", this.fullClassName), e);
        }
    }
}

