/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.compiler;

import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;

public final class DiagnosticsReporting
implements DiagnosticListener<JavaFileObject> {
    private static final EnumMap<Diagnostic.Kind, LogLevel> LEVEL_MAP = Maps.newEnumMap(Diagnostic.Kind.class);
    private final ListProcessingReport report = new ListProcessingReport(LogLevel.DEBUG, LogLevel.NONE);

    @Override
    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
        LogLevel level = LEVEL_MAP.get((Object)diagnostic.getKind());
        ProcessingMessage message = new ProcessingMessage().setMessage(diagnostic.getMessage(Locale.ENGLISH)).setLogLevel(level).put("line", (Object)diagnostic.getLineNumber()).put("column", (Object)diagnostic.getColumnNumber());
        this.report.log(level, message);
    }

    public ProcessingReport getReport() {
        return this.report;
    }

    static {
        LEVEL_MAP.put(Diagnostic.Kind.ERROR, LogLevel.ERROR);
        LEVEL_MAP.put(Diagnostic.Kind.MANDATORY_WARNING, LogLevel.WARNING);
        LEVEL_MAP.put(Diagnostic.Kind.WARNING, LogLevel.WARNING);
        LEVEL_MAP.put(Diagnostic.Kind.NOTE, LogLevel.INFO);
        LEVEL_MAP.put(Diagnostic.Kind.OTHER, LogLevel.DEBUG);
    }
}

