/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jjschema;

import com.github.fge.compiler.CompilerOutput;
import com.github.fge.compiler.CompilerProcessor;
import com.github.fge.compiler.CompilingException;
import com.github.fge.jjschema.JJSchemaProcessor;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.RawProcessor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.util.ValueHolder;
import java.io.File;

public final class JJSchemaFromSource
extends RawProcessor<String, SchemaTree> {
    private static final JJSchemaFromSource INSTANCE = new JJSchemaFromSource();
    private final CompilerProcessor compiler = new CompilerProcessor();
    private final JJSchemaProcessor classToSchema = new JJSchemaProcessor();

    public static JJSchemaFromSource getInstance() {
        return INSTANCE;
    }

    private JJSchemaFromSource() {
        super("source", "schema");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SchemaTree rawProcess(ProcessingReport report, String input) throws ProcessingException {
        ValueHolder holder = ValueHolder.hold((String)"source", (Object)input);
        CompilerOutput compilerOutput = this.compiler.process(report, (ValueHolder<String>)holder);
        try {
            ValueHolder<Class<?>> input1 = JJSchemaFromSource.extractClass(compilerOutput);
            SchemaTree schemaTree = report.isSuccess() ? (SchemaTree)this.classToSchema.process(report, input1).getValue() : null;
            return schemaTree;
        }
        finally {
            String dir = compilerOutput.getDirectory().getDirectory();
            JJSchemaFromSource.rmDashRf(new File(dir));
        }
    }

    private static ValueHolder<Class<?>> extractClass(CompilerOutput compilerOutput) throws CompilingException {
        Class<?> c = compilerOutput.getGeneratedClass();
        return ValueHolder.hold((String)"class", c);
    }

    private static void rmDashRf(File file) throws ProcessingException {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                JJSchemaFromSource.rmDashRf(f);
            }
        }
        if (!file.delete()) {
            throw new ProcessingException("cannot cleanup directory");
        }
    }
}

