/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.validator.helpers.NumericValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processors.data.ValidationData;
import com.github.fge.jsonschema.report.ProcessingReport;
import java.math.BigDecimal;

public abstract class DivisorValidator
extends NumericValidator {
    protected DivisorValidator(String keyword, JsonNode digest) {
        super(keyword, digest);
    }

    @Override
    protected final void validateLong(ProcessingReport report, ValidationData data) throws ProcessingException {
        long longValue;
        JsonNode node = data.getInstance().getNode();
        long instanceValue = node.longValue();
        long remainder = instanceValue % (longValue = this.number.longValue());
        if (remainder == 0L) {
            return;
        }
        report.error(this.newMsg(data).message((Object)KeywordValidationMessages.NON_ZERO_DIVISION_REMAINDER).put("value", node).put("divisor", this.number));
    }

    @Override
    protected final void validateDecimal(ProcessingReport report, ValidationData data) throws ProcessingException {
        BigDecimal decimalValue;
        JsonNode node = data.getInstance().getNode();
        BigDecimal instanceValue = node.decimalValue();
        BigDecimal remainder = instanceValue.remainder(decimalValue = this.number.decimalValue());
        if (remainder.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        report.error(this.newMsg(data).message((Object)KeywordValidationMessages.NON_ZERO_DIVISION_REMAINDER).put("value", node).put("divisor", this.number));
    }
}

