/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.validation;

import com.github.fge.jsonschema.exceptions.InvalidSchemaException;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ProcessorChain;
import com.github.fge.jsonschema.processors.build.ValidatorBuilder;
import com.github.fge.jsonschema.processors.data.SchemaContext;
import com.github.fge.jsonschema.processors.data.SchemaHolder;
import com.github.fge.jsonschema.processors.data.ValidatorList;
import com.github.fge.jsonschema.processors.digest.SchemaDigester;
import com.github.fge.jsonschema.processors.format.FormatProcessor;
import com.github.fge.jsonschema.processors.ref.RefResolver;
import com.github.fge.jsonschema.processors.syntax.SyntaxProcessor;
import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;

public final class ValidationChain
implements Processor<SchemaContext, ValidatorList> {
    private final Processor<SchemaHolder, SchemaHolder> refSyntax;
    private final Processor<SchemaContext, ValidatorList> processor;

    public ValidationChain(RefResolver refResolver, Library library, boolean useFormat) {
        SyntaxProcessor syntaxProcessor = new SyntaxProcessor(library.getSyntaxCheckers());
        this.refSyntax = ProcessorChain.startWith((Processor)refResolver).chainWith((Processor)syntaxProcessor).getProcessor();
        SchemaDigester digester = new SchemaDigester(library.getDigesters());
        ValidatorBuilder builder = new ValidatorBuilder(library.getValidators());
        ProcessorChain chain = ProcessorChain.startWith((Processor)digester).chainWith((Processor)builder);
        if (useFormat) {
            FormatProcessor formatProcessor = new FormatProcessor(library.getFormatAttributes());
            chain = chain.chainWith((Processor)formatProcessor);
        }
        this.processor = chain.getProcessor();
    }

    public ValidatorList process(ProcessingReport report, SchemaContext input) throws ProcessingException {
        SchemaHolder in = new SchemaHolder(input.getSchema());
        SchemaHolder out = (SchemaHolder)this.refSyntax.process(report, (MessageProvider)in);
        if (!report.isSuccess()) {
            throw new InvalidSchemaException(new ProcessingMessage().message((Object)SyntaxMessages.INVALID_SCHEMA));
        }
        SchemaContext output = new SchemaContext((SchemaTree)out.getValue(), input.getInstanceType());
        return (ValidatorList)this.processor.process(report, (MessageProvider)output);
    }

    public String toString() {
        return this.refSyntax + " -> " + this.processor;
    }
}

