/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.messages.KeywordValidationMessages;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.JacksonUtils;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class DependenciesValidator
extends AbstractKeywordValidator {
    private static final JsonPointer BASE_PTR = JsonPointer.empty().append("dependencies");
    private final Multimap<String, String> propertyDeps;
    private final Set<String> schemaDeps;

    public DependenciesValidator(JsonNode digest) {
        super("dependencies");
        ImmutableMultimap.Builder mapBuilder = ImmutableMultimap.builder();
        Map<String, JsonNode> map = JacksonUtils.asMap(digest.get("propertyDeps"));
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            String key = entry.getKey();
            for (JsonNode element : entry.getValue()) {
                mapBuilder.put((Object)key, (Object)element.textValue());
            }
        }
        this.propertyDeps = mapBuilder.build();
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (JsonNode node : digest.get("schemaDeps")) {
            setBuilder.add((Object)node.textValue());
        }
        this.schemaDeps = setBuilder.build();
    }

    @Override
    public void validate(Processor<ValidationData, ProcessingReport> processor, ProcessingReport report, ValidationData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        HashSet fields = Sets.newHashSet((Iterator)instance.fieldNames());
        for (String field : this.propertyDeps.keySet()) {
            if (!fields.contains(field)) continue;
            Collection collection = this.propertyDeps.get((Object)field);
            LinkedHashSet set = Sets.newLinkedHashSet((Iterable)collection);
            set.removeAll(fields);
            if (set.isEmpty()) continue;
            report.error(this.newMsg(data).msg(KeywordValidationMessages.MISSING_PROPERTY_DEPS).put("property", field).put("required", collection).put("missing", set));
        }
        if (this.schemaDeps.isEmpty()) {
            return;
        }
        SchemaTree tree = data.getSchema();
        for (String field : this.schemaDeps) {
            if (!fields.contains(field)) continue;
            ValidationData newData = data.withSchema(tree.append(BASE_PTR.append(field)));
            processor.process(report, newData);
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.propertyDeps.size() + " property dependencies, " + this.schemaDeps.size() + " schema dependencies";
    }
}

