/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ValidationData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.NodeType;

public abstract class NumericValidator
extends AbstractKeywordValidator {
    protected final JsonNode number;
    private final boolean isLong;

    protected NumericValidator(String keyword, JsonNode digest) {
        super(keyword);
        this.number = digest.get(keyword);
        this.isLong = digest.get("valueIsLong").booleanValue();
    }

    @Override
    public final void validate(Processor<ValidationData, ProcessingReport> processor, ProcessingReport report, ValidationData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        if (NumericValidator.valueIsLong(instance) && this.isLong) {
            this.validateLong(report, data);
        } else {
            this.validateDecimal(report, data);
        }
    }

    protected abstract void validateLong(ProcessingReport var1, ValidationData var2) throws ProcessingException;

    protected abstract void validateDecimal(ProcessingReport var1, ValidationData var2) throws ProcessingException;

    @Override
    public final String toString() {
        return this.keyword + ": " + this.number;
    }

    private static boolean valueIsLong(JsonNode node) {
        return NodeType.getNodeType(node) == NodeType.INTEGER && node.canConvertToLong();
    }
}

