/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.messages.FormatMessages;
import com.github.fge.jsonschema.processors.data.ValidationData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.NodeType;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public final class EmailAttribute
extends AbstractFormatAttribute {
    private static final FormatAttribute INSTANCE = new EmailAttribute();

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    private EmailAttribute() {
        super("email", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void validate(ProcessingReport report, ValidationData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        try {
            new InternetAddress(instance.textValue(), true);
        }
        catch (AddressException ignored) {
            report.error(this.newMsg(data, FormatMessages.INVALID_EMAIL));
        }
    }
}

