/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.load;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.fge.jsonschema.cfg.LoadingConfiguration;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.load.URIDownloader;
import com.github.fge.jsonschema.messages.RefProcessingMessages;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.util.JacksonUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;

public final class URIManager {
    private static final ObjectReader READER = JacksonUtils.getReader();
    private final Map<String, URIDownloader> downloaders;
    private final Map<URI, URI> schemaRedirects;

    public URIManager() {
        this(LoadingConfiguration.byDefault());
    }

    public URIManager(LoadingConfiguration cfg) {
        this.downloaders = cfg.getDownloaders().entries();
        this.schemaRedirects = cfg.getSchemaRedirects();
    }

    public JsonNode getContent(URI uri) throws ProcessingException {
        Preconditions.checkNotNull((Object)uri, (Object)"null URI");
        URI target = this.schemaRedirects.containsKey(uri) ? this.schemaRedirects.get(uri) : uri;
        ProcessingMessage msg = new ProcessingMessage().put("uri", (Object)uri);
        if (!target.isAbsolute()) {
            throw new ProcessingException(msg.message((Object)RefProcessingMessages.URI_NOT_ABSOLUTE));
        }
        String scheme = target.getScheme();
        URIDownloader downloader = this.downloaders.get(scheme);
        if (downloader == null) {
            throw new ProcessingException(msg.message((Object)RefProcessingMessages.UNHANDLED_SCHEME).put("scheme", scheme));
        }
        try {
            InputStream in = downloader.fetch(target);
            return READER.readTree(in);
        }
        catch (JsonProcessingException e) {
            throw new ProcessingException(msg.message((Object)RefProcessingMessages.URI_NOT_JSON).put("parsingMessage", e.getOriginalMessage()));
        }
        catch (IOException e) {
            throw new ProcessingException(msg.message((Object)RefProcessingMessages.URI_IOERROR).put("exceptionMessage", e.getMessage()));
        }
    }
}

