/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.ref;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.load.SchemaLoader;
import com.github.fge.jsonschema.messages.RefProcessingMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.SchemaHolder;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.AsJson;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;

public final class RefResolver
implements Processor<SchemaHolder, SchemaHolder> {
    private final SchemaLoader loader;

    public RefResolver(SchemaLoader loader) {
        this.loader = loader;
    }

    public SchemaHolder process(ProcessingReport report, SchemaHolder input) throws ProcessingException {
        return new SchemaHolder(this.loadRef((SchemaTree)input.getValue()));
    }

    private static JsonRef nodeAsRef(JsonNode node) {
        JsonNode refNode = node.path("$ref");
        if (!refNode.isTextual()) {
            return null;
        }
        try {
            return JsonRef.fromString((String)refNode.textValue());
        }
        catch (JsonReferenceException ignored) {
            return null;
        }
    }

    private SchemaTree loadRef(SchemaTree orig) throws ProcessingException {
        JsonNode node;
        JsonRef ref;
        LinkedHashSet refs = Sets.newLinkedHashSet();
        SchemaTree tree = orig;
        ProcessingMessage message = new ProcessingMessage().put("schema", (AsJson)tree);
        while ((ref = RefResolver.nodeAsRef(node = tree.getNode())) != null) {
            JsonPointer ptr;
            if (!refs.add(ref = tree.resolve(ref))) {
                message.message((Object)RefProcessingMessages.REF_LOOP).put("ref", (Object)ref).put("path", (Iterable)refs);
                throw new ProcessingException(message);
            }
            if (!tree.containsRef(ref)) {
                tree = this.loader.get(ref.getLocator());
            }
            if ((ptr = tree.matchingPointer(ref)) == null) {
                message.message((Object)RefProcessingMessages.DANGLING_REF).put("ref", (Object)ref);
                throw new ProcessingException(message);
            }
            tree = tree.setPointer(ptr);
        }
        return tree;
    }

    public String toString() {
        return "ref resolver";
    }
}

