/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.digest;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.digest.Digester;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.SchemaContext;
import com.github.fge.jsonschema.processors.data.SchemaDigest;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class SchemaDigester
implements Processor<SchemaContext, SchemaDigest> {
    private final ListMultimap<NodeType, String> typeMap = ArrayListMultimap.create();
    private final Map<String, Digester> digesterMap = Maps.newHashMap();

    public SchemaDigester(Library library) {
        this(library.getDigesters());
    }

    public SchemaDigester(Dictionary<Digester> dict) {
        Map map = dict.entries();
        for (Map.Entry entry : map.entrySet()) {
            String keyword = (String)entry.getKey();
            Digester digester = (Digester)entry.getValue();
            this.digesterMap.put(keyword, digester);
            for (NodeType type : digester.supportedTypes()) {
                this.typeMap.put((Object)type, (Object)keyword);
            }
        }
    }

    public SchemaDigest process(ProcessingReport report, SchemaContext input) throws ProcessingException {
        JsonNode schema = input.getSchema().getNode();
        NodeType type = input.getInstanceType();
        HashMap map = Maps.newHashMap(this.buildDigests(schema));
        map.keySet().retainAll(this.typeMap.get((Object)type));
        return new SchemaDigest(input, map);
    }

    private Map<String, JsonNode> buildDigests(JsonNode schema) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashMap map = Maps.newHashMap(this.digesterMap);
        map.keySet().retainAll(Sets.newHashSet((Iterator)schema.fieldNames()));
        for (Map.Entry entry : map.entrySet()) {
            builder.put(entry.getKey(), (Object)((Digester)entry.getValue()).digest(schema));
        }
        return builder.build();
    }

    public String toString() {
        return "schema digester";
    }
}

