/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.load.SchemaLoader;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.processing.ProcessingResult;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.processors.validation.ValidationProcessor;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.report.ReportProvider;
import com.github.fge.jsonschema.tree.JsonTree;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.tree.SimpleJsonTree;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JsonValidator {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private final SchemaLoader loader;
    private final ValidationProcessor processor;
    private final ReportProvider reportProvider;

    JsonValidator(SchemaLoader loader, ValidationProcessor processor, ReportProvider reportProvider) {
        this.loader = loader;
        this.processor = processor;
        this.reportProvider = reportProvider;
    }

    public ProcessingReport validate(JsonNode schema, JsonNode instance) throws ProcessingException {
        ProcessingReport report = this.reportProvider.newReport();
        FullData data = this.buildData(schema, instance);
        return ProcessingResult.of((Processor)this.processor, (ProcessingReport)report, (MessageProvider)data).getReport();
    }

    public ProcessingReport validateUnchecked(JsonNode schema, JsonNode instance) {
        ProcessingReport report = this.reportProvider.newReport();
        FullData data = this.buildData(schema, instance);
        return ProcessingResult.uncheckedResult((Processor)this.processor, (ProcessingReport)report, (MessageProvider)data).getReport();
    }

    JsonSchema buildJsonSchema(JsonNode schema, JsonPointer pointer) throws ProcessingException {
        SchemaTree tree = this.loader.load(schema).setPointer(pointer);
        if (tree.getNode().isMissingNode()) {
            throw new JsonReferenceException(new ProcessingMessage().setMessage(BUNDLE.getMessage("danglingRef")));
        }
        return new JsonSchema(this.processor, tree, this.reportProvider);
    }

    JsonSchema buildJsonSchema(String uri) throws ProcessingException {
        JsonRef ref = JsonRef.fromString((String)uri);
        if (!ref.isLegal()) {
            throw new JsonReferenceException(new ProcessingMessage().setMessage(BUNDLE.getMessage("illegalJsonRef")));
        }
        SchemaTree tree = this.loader.get(ref.getLocator()).setPointer(ref.getPointer());
        if (tree.getNode().isMissingNode()) {
            throw new JsonReferenceException(new ProcessingMessage().setMessage(BUNDLE.getMessage("danglingRef")));
        }
        return new JsonSchema(this.processor, tree, this.reportProvider);
    }

    Processor<FullData, FullData> getProcessor() {
        return this.processor;
    }

    private FullData buildData(JsonNode schema, JsonNode instance) {
        BUNDLE.checkNotNull((Object)schema, "nullSchema");
        MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class).checkNotNull((Object)instance, "nullInstance");
        SchemaTree schemaTree = this.loader.load(schema);
        SimpleJsonTree tree = new SimpleJsonTree(instance);
        return new FullData(schemaTree, (JsonTree)tree);
    }
}

