/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.render;

import com.github.fge.uritemplate.CharMatchers;
import com.github.fge.uritemplate.URITemplateException;
import com.github.fge.uritemplate.expression.ExpressionType;
import com.github.fge.uritemplate.vars.specs.VariableSpec;
import com.github.fge.uritemplate.vars.values.VariableValue;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import java.util.List;

public abstract class ValueRenderer {
    protected final boolean named;
    protected final String ifEmpty;
    private final CharMatcher matcher;

    protected ValueRenderer(ExpressionType type) {
        this.named = type.isNamed();
        this.ifEmpty = type.getIfEmpty();
        this.matcher = type.isRawExpand() ? CharMatchers.RESERVED_PLUS_UNRESERVED : CharMatchers.UNRESERVED;
    }

    public abstract List<String> render(VariableSpec var1, VariableValue var2) throws URITemplateException;

    protected final String pctEncode(String s) {
        int size = s.length();
        StringBuilder sb = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            sb.append(this.matcher.matches(c) ? Character.valueOf(c) : ValueRenderer.encodeChar(c));
        }
        return sb.toString();
    }

    private static String encodeChar(char c) {
        String tmp = Character.toString(c);
        byte[] bytes = tmp.getBytes(Charsets.UTF_8);
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%%%02x", b));
        }
        return sb.toString();
    }
}

