/*
 * Decompiled with CFR 0.152.
 */
package com.fourmob.datetimepicker.date;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.SystemClock;
import android.os.Vibrator;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.text.format.DateUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.fourmob.datetimepicker.R;
import com.fourmob.datetimepicker.Utils;
import com.fourmob.datetimepicker.date.AccessibleDateAnimator;
import com.fourmob.datetimepicker.date.DatePickerController;
import com.fourmob.datetimepicker.date.DayPickerView;
import com.fourmob.datetimepicker.date.SimpleMonthAdapter;
import com.fourmob.datetimepicker.date.YearPickerView;
import com.nineoldandroids.animation.ObjectAnimator;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public class DatePickerDialog
extends DialogFragment
implements View.OnClickListener,
DatePickerController {
    private static final String KEY_SELECTED_YEAR = "year";
    private static final String KEY_SELECTED_MONTH = "month";
    private static final String KEY_SELECTED_DAY = "day";
    private static final String KEY_VIBRATE = "vibrate";
    private static final int MAX_YEAR = 2037;
    private static final int MIN_YEAR = 1902;
    private static final int UNINITIALIZED = -1;
    private static final int MONTH_AND_DAY_VIEW = 0;
    private static final int YEAR_VIEW = 1;
    public static final int ANIMATION_DELAY = 500;
    public static final String KEY_WEEK_START = "week_start";
    public static final String KEY_YEAR_START = "year_start";
    public static final String KEY_YEAR_END = "year_end";
    public static final String KEY_CURRENT_VIEW = "current_view";
    public static final String KEY_LIST_POSITION = "list_position";
    public static final String KEY_LIST_POSITION_OFFSET = "list_position_offset";
    private static SimpleDateFormat DAY_FORMAT = new SimpleDateFormat("dd", Locale.getDefault());
    private static SimpleDateFormat YEAR_FORMAT = new SimpleDateFormat("yyyy", Locale.getDefault());
    private DateFormatSymbols mDateFormatSymbols = new DateFormatSymbols();
    private final Calendar mCalendar = Calendar.getInstance();
    private HashSet<OnDateChangedListener> mListeners = new HashSet();
    private OnDateSetListener mCallBack;
    private AccessibleDateAnimator mAnimator;
    private boolean mDelayAnimation = true;
    private long mLastVibrate;
    private int mCurrentView = -1;
    private int mWeekStart = this.mCalendar.getFirstDayOfWeek();
    private int mMaxYear = 2037;
    private int mMinYear = 1902;
    private String mDayPickerDescription;
    private String mYearPickerDescription;
    private String mSelectDay;
    private String mSelectYear;
    private TextView mDayOfWeekView;
    private DayPickerView mDayPickerView;
    private Button mDoneButton;
    private LinearLayout mMonthAndDayView;
    private TextView mSelectedDayTextView;
    private TextView mSelectedMonthTextView;
    private Vibrator mVibrator;
    private YearPickerView mYearPickerView;
    private TextView mYearView;
    private boolean mVibrate = true;
    private boolean mCloseOnSingleTapDay;

    private void adjustDayInMonthIfNeeded(int month, int year) {
        int daysInMonth;
        int day = this.mCalendar.get(5);
        if (day > (daysInMonth = Utils.getDaysInMonth(month, year))) {
            this.mCalendar.set(5, daysInMonth);
        }
    }

    public static DatePickerDialog newInstance(OnDateSetListener onDateSetListener, int year, int month, int day) {
        return DatePickerDialog.newInstance(onDateSetListener, year, month, day, true);
    }

    public static DatePickerDialog newInstance(OnDateSetListener onDateSetListener, int year, int month, int day, boolean vibrate) {
        DatePickerDialog datePickerDialog = new DatePickerDialog();
        datePickerDialog.initialize(onDateSetListener, year, month, day, vibrate);
        return datePickerDialog;
    }

    public void setVibrate(boolean vibrate) {
        this.mVibrate = vibrate;
    }

    private void setCurrentView(int currentView) {
        this.setCurrentView(currentView, false);
    }

    private void setCurrentView(int currentView, boolean forceRefresh) {
        long timeInMillis = this.mCalendar.getTimeInMillis();
        switch (currentView) {
            case 0: {
                ObjectAnimator monthDayAnim = Utils.getPulseAnimator((View)this.mMonthAndDayView, 0.9f, 1.05f);
                if (this.mDelayAnimation) {
                    monthDayAnim.setStartDelay(500L);
                    this.mDelayAnimation = false;
                }
                this.mDayPickerView.onDateChanged();
                if (this.mCurrentView != currentView || forceRefresh) {
                    this.mMonthAndDayView.setSelected(true);
                    this.mYearView.setSelected(false);
                    this.mAnimator.setDisplayedChild(0);
                    this.mCurrentView = currentView;
                }
                monthDayAnim.start();
                String monthDayDesc = DateUtils.formatDateTime((Context)this.getActivity(), (long)timeInMillis, (int)16);
                this.mAnimator.setContentDescription(this.mDayPickerDescription + ": " + monthDayDesc);
                Utils.tryAccessibilityAnnounce((View)this.mAnimator, this.mSelectDay);
                break;
            }
            case 1: {
                ObjectAnimator yearAnim = Utils.getPulseAnimator((View)this.mYearView, 0.85f, 1.1f);
                if (this.mDelayAnimation) {
                    yearAnim.setStartDelay(500L);
                    this.mDelayAnimation = false;
                }
                this.mYearPickerView.onDateChanged();
                if (this.mCurrentView != currentView || forceRefresh) {
                    this.mMonthAndDayView.setSelected(false);
                    this.mYearView.setSelected(true);
                    this.mAnimator.setDisplayedChild(1);
                    this.mCurrentView = currentView;
                }
                yearAnim.start();
                String dayDesc = YEAR_FORMAT.format(timeInMillis);
                this.mAnimator.setContentDescription(this.mYearPickerDescription + ": " + dayDesc);
                Utils.tryAccessibilityAnnounce((View)this.mAnimator, this.mSelectYear);
            }
        }
    }

    private void updateDisplay(boolean announce) {
        if (this.mDayOfWeekView != null) {
            this.mCalendar.setFirstDayOfWeek(this.mWeekStart);
            this.mDayOfWeekView.setText((CharSequence)this.mDateFormatSymbols.getWeekdays()[this.mCalendar.get(7)].toUpperCase(Locale.getDefault()));
        }
        this.mSelectedMonthTextView.setText((CharSequence)this.mDateFormatSymbols.getMonths()[this.mCalendar.get(2)].toUpperCase(Locale.getDefault()));
        this.mSelectedDayTextView.setText((CharSequence)DAY_FORMAT.format(this.mCalendar.getTime()));
        this.mYearView.setText((CharSequence)YEAR_FORMAT.format(this.mCalendar.getTime()));
        long millis = this.mCalendar.getTimeInMillis();
        this.mAnimator.setDateMillis(millis);
        int flags = 24;
        String monthAndDayText = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
        this.mMonthAndDayView.setContentDescription((CharSequence)monthAndDayText);
        if (announce) {
            flags = 20;
            String fullDateText = DateUtils.formatDateTime((Context)this.getActivity(), (long)millis, (int)flags);
            Utils.tryAccessibilityAnnounce((View)this.mAnimator, fullDateText);
        }
    }

    private void updatePickers() {
        Iterator<OnDateChangedListener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onDateChanged();
        }
    }

    @Override
    public int getFirstDayOfWeek() {
        return this.mWeekStart;
    }

    @Override
    public int getMaxYear() {
        return this.mMaxYear;
    }

    @Override
    public int getMinYear() {
        return this.mMinYear;
    }

    @Override
    public SimpleMonthAdapter.CalendarDay getSelectedDay() {
        return new SimpleMonthAdapter.CalendarDay(this.mCalendar);
    }

    public void initialize(OnDateSetListener onDateSetListener, int year, int month, int day, boolean vibrate) {
        if (year > 2037) {
            throw new IllegalArgumentException("year end must < 2037");
        }
        if (year < 1902) {
            throw new IllegalArgumentException("year end must > 1902");
        }
        this.mCallBack = onDateSetListener;
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(5, day);
        this.mVibrate = vibrate;
    }

    public void onClick(View view) {
        this.tryVibrate();
        if (view.getId() == R.id.date_picker_year) {
            this.setCurrentView(1);
        } else if (view.getId() == R.id.date_picker_month_and_day) {
            this.setCurrentView(0);
        }
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        FragmentActivity activity = this.getActivity();
        activity.getWindow().setSoftInputMode(3);
        this.mVibrator = (Vibrator)activity.getSystemService("vibrator");
        if (bundle != null) {
            this.mCalendar.set(1, bundle.getInt(KEY_SELECTED_YEAR));
            this.mCalendar.set(2, bundle.getInt(KEY_SELECTED_MONTH));
            this.mCalendar.set(5, bundle.getInt(KEY_SELECTED_DAY));
            this.mVibrate = bundle.getBoolean(KEY_VIBRATE);
        }
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup parent, Bundle bundle) {
        this.getDialog().getWindow().requestFeature(1);
        View view = layoutInflater.inflate(R.layout.date_picker_dialog, null);
        this.mDayOfWeekView = (TextView)view.findViewById(R.id.date_picker_header);
        this.mMonthAndDayView = (LinearLayout)view.findViewById(R.id.date_picker_month_and_day);
        this.mMonthAndDayView.setOnClickListener((View.OnClickListener)this);
        this.mSelectedMonthTextView = (TextView)view.findViewById(R.id.date_picker_month);
        this.mSelectedDayTextView = (TextView)view.findViewById(R.id.date_picker_day);
        this.mYearView = (TextView)view.findViewById(R.id.date_picker_year);
        this.mYearView.setOnClickListener((View.OnClickListener)this);
        int listPosition = -1;
        int currentView = 0;
        int listPositionOffset = 0;
        if (bundle != null) {
            this.mWeekStart = bundle.getInt(KEY_WEEK_START);
            this.mMinYear = bundle.getInt(KEY_YEAR_START);
            this.mMaxYear = bundle.getInt(KEY_YEAR_END);
            currentView = bundle.getInt(KEY_CURRENT_VIEW);
            listPosition = bundle.getInt(KEY_LIST_POSITION);
            listPositionOffset = bundle.getInt(KEY_LIST_POSITION_OFFSET);
        }
        FragmentActivity activity = this.getActivity();
        this.mDayPickerView = new DayPickerView((Context)activity, this);
        this.mYearPickerView = new YearPickerView((Context)activity, this);
        Resources resources = this.getResources();
        this.mDayPickerDescription = resources.getString(R.string.day_picker_description);
        this.mSelectDay = resources.getString(R.string.select_day);
        this.mYearPickerDescription = resources.getString(R.string.year_picker_description);
        this.mSelectYear = resources.getString(R.string.select_year);
        this.mAnimator = (AccessibleDateAnimator)view.findViewById(R.id.animator);
        this.mAnimator.addView((View)this.mDayPickerView);
        this.mAnimator.addView((View)this.mYearPickerView);
        this.mAnimator.setDateMillis(this.mCalendar.getTimeInMillis());
        AlphaAnimation inAlphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        inAlphaAnimation.setDuration(300L);
        this.mAnimator.setInAnimation((Animation)inAlphaAnimation);
        AlphaAnimation outAlphaAnimation = new AlphaAnimation(1.0f, 0.0f);
        outAlphaAnimation.setDuration(300L);
        this.mAnimator.setOutAnimation((Animation)outAlphaAnimation);
        this.mDoneButton = (Button)view.findViewById(R.id.done);
        this.mDoneButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DatePickerDialog.this.onDoneButtonClick();
            }
        });
        this.updateDisplay(false);
        this.setCurrentView(currentView, true);
        if (listPosition != -1) {
            if (currentView == 0) {
                this.mDayPickerView.postSetSelection(listPosition);
            }
            if (currentView == 1) {
                this.mYearPickerView.postSetSelectionFromTop(listPosition, listPositionOffset);
            }
        }
        return view;
    }

    private void onDoneButtonClick() {
        this.tryVibrate();
        if (this.mCallBack != null) {
            this.mCallBack.onDateSet(this, this.mCalendar.get(1), this.mCalendar.get(2), this.mCalendar.get(5));
        }
        this.dismiss();
    }

    @Override
    public void onDayOfMonthSelected(int year, int month, int day) {
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(5, day);
        this.updatePickers();
        this.updateDisplay(true);
        if (this.mCloseOnSingleTapDay) {
            this.onDoneButtonClick();
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putInt(KEY_SELECTED_YEAR, this.mCalendar.get(1));
        bundle.putInt(KEY_SELECTED_MONTH, this.mCalendar.get(2));
        bundle.putInt(KEY_SELECTED_DAY, this.mCalendar.get(5));
        bundle.putInt(KEY_WEEK_START, this.mWeekStart);
        bundle.putInt(KEY_YEAR_START, this.mMinYear);
        bundle.putInt(KEY_YEAR_END, this.mMaxYear);
        bundle.putInt(KEY_CURRENT_VIEW, this.mCurrentView);
        int listPosition = -1;
        if (this.mCurrentView == 0) {
            listPosition = this.mDayPickerView.getMostVisiblePosition();
        }
        if (this.mCurrentView == 1) {
            listPosition = this.mYearPickerView.getFirstVisiblePosition();
            bundle.putInt(KEY_LIST_POSITION_OFFSET, this.mYearPickerView.getFirstPositionOffset());
        }
        bundle.putInt(KEY_LIST_POSITION, listPosition);
        bundle.putBoolean(KEY_VIBRATE, this.mVibrate);
    }

    @Override
    public void onYearSelected(int year) {
        this.adjustDayInMonthIfNeeded(this.mCalendar.get(2), year);
        this.mCalendar.set(1, year);
        this.updatePickers();
        this.setCurrentView(0);
        this.updateDisplay(true);
    }

    @Override
    public void registerOnDateChangedListener(OnDateChangedListener onDateChangedListener) {
        this.mListeners.add(onDateChangedListener);
    }

    public void setFirstDayOfWeek(int startOfWeek) {
        if (startOfWeek < 1 || startOfWeek > 7) {
            throw new IllegalArgumentException("Value must be between Calendar.SUNDAY and Calendar.SATURDAY");
        }
        this.mWeekStart = startOfWeek;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    public void setOnDateSetListener(OnDateSetListener onDateSetListener) {
        this.mCallBack = onDateSetListener;
    }

    public void setYearRange(int minYear, int maxYear) {
        if (maxYear <= minYear) {
            throw new IllegalArgumentException("Year end must be larger than year start");
        }
        if (maxYear > 2037) {
            throw new IllegalArgumentException("max year end must < 2037");
        }
        if (minYear < 1902) {
            throw new IllegalArgumentException("min year end must > 1902");
        }
        this.mMinYear = minYear;
        this.mMaxYear = maxYear;
        if (this.mDayPickerView != null) {
            this.mDayPickerView.onChange();
        }
    }

    @Override
    public void tryVibrate() {
        long timeInMillis;
        if (this.mVibrator != null && this.mVibrate && (timeInMillis = SystemClock.uptimeMillis()) - this.mLastVibrate >= 125L) {
            this.mVibrator.vibrate(5L);
            this.mLastVibrate = timeInMillis;
        }
    }

    public void setCloseOnSingleTapDay(boolean closeOnSingleTapDay) {
        this.mCloseOnSingleTapDay = closeOnSingleTapDay;
    }

    public static interface OnDateSetListener {
        public void onDateSet(DatePickerDialog var1, int var2, int var3, int var4);
    }

    static interface OnDateChangedListener {
        public void onDateChanged();
    }
}

