/*
 * Decompiled with CFR 0.152.
 */
package com.fourmob.datetimepicker.date;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.fourmob.datetimepicker.date.DatePickerController;
import com.fourmob.datetimepicker.date.DatePickerDialog;
import com.fourmob.datetimepicker.date.SimpleMonthAdapter;
import com.fourmob.datetimepicker.date.SimpleMonthView;

public class DayPickerView
extends ListView
implements AbsListView.OnScrollListener,
DatePickerDialog.OnDateChangedListener {
    protected static final int GOTO_SCROLL_DURATION = 250;
    protected static final int SCROLL_CHANGE_DELAY = 40;
    public static int LIST_TOP_OFFSET = -1;
    protected Context mContext;
    protected Handler mHandler = new Handler();
    protected SimpleMonthAdapter mAdapter;
    private final DatePickerController mController;
    protected int mCurrentMonthDisplayed;
    protected int mCurrentScrollState = 0;
    private boolean mPerformingScroll;
    protected long mPreviousScrollPosition;
    protected int mPreviousScrollState = 0;
    protected ScrollStateRunnable mScrollStateChangedRunnable = new ScrollStateRunnable();
    protected SimpleMonthAdapter.CalendarDay mSelectedDay = new SimpleMonthAdapter.CalendarDay();
    protected SimpleMonthAdapter.CalendarDay mTempDay = new SimpleMonthAdapter.CalendarDay();
    protected int mNumWeeks = 6;
    protected boolean mShowWeekNumber = false;
    protected int mDaysPerWeek = 7;
    protected float mFriction = 1.0f;

    public DayPickerView(Context context, DatePickerController datePickerController) {
        super(context);
        this.mController = datePickerController;
        this.mController.registerOnDateChangedListener(this);
        this.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
        this.setDrawSelectorOnTop(false);
        this.init(context);
        this.onDateChanged();
    }

    public int getMostVisiblePosition() {
        View child;
        int firstPosition = this.getFirstVisiblePosition();
        int height = this.getHeight();
        int maxDisplayedHeight = 0;
        int mostVisibleIndex = 0;
        int i = 0;
        int bottom = 0;
        while (bottom < height && (child = this.getChildAt(i)) != null) {
            bottom = child.getBottom();
            int displayedHeight = Math.min(bottom, height) - Math.max(0, child.getTop());
            if (displayedHeight > maxDisplayedHeight) {
                mostVisibleIndex = i;
                maxDisplayedHeight = displayedHeight;
            }
            ++i;
        }
        return firstPosition + mostVisibleIndex;
    }

    public boolean goTo(SimpleMonthAdapter.CalendarDay day, boolean animate, boolean setSelected, boolean forceScroll) {
        View child;
        if (setSelected) {
            this.mSelectedDay.set(day);
        }
        this.mTempDay.set(day);
        int position = (day.year - this.mController.getMinYear()) * 12 + day.month;
        int i = 0;
        int top = 0;
        while ((child = this.getChildAt(i++)) != null && (top = child.getTop()) < 0) {
        }
        int selectedPosition = child != null ? this.getPositionForView(child) : 0;
        if (setSelected) {
            this.mAdapter.setSelectedDay(this.mSelectedDay);
        }
        if (position != selectedPosition || forceScroll) {
            this.setMonthDisplayed(this.mTempDay);
            this.mPreviousScrollState = 2;
            if (animate && Build.VERSION.SDK_INT >= 11) {
                this.smoothScrollToPositionFromTop(position, LIST_TOP_OFFSET, 250);
                return true;
            }
            this.postSetSelection(position);
        } else if (setSelected) {
            this.setMonthDisplayed(this.mSelectedDay);
        }
        return false;
    }

    public void init(Context paramContext) {
        this.mContext = paramContext;
        this.setUpListView();
        this.setUpAdapter();
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        if (this.mPerformingScroll) {
            this.mPerformingScroll = false;
        }
    }

    public void onChange() {
        this.setUpAdapter();
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    @Override
    public void onDateChanged() {
        this.goTo(this.mController.getSelectedDay(), false, true, true);
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        long currScroll;
        SimpleMonthView child = (SimpleMonthView)view.getChildAt(0);
        if (child == null) {
            return;
        }
        this.mPreviousScrollPosition = currScroll = (long)(view.getFirstVisiblePosition() * child.getHeight() - child.getBottom());
        this.mPreviousScrollState = this.mCurrentScrollState;
    }

    public void onScrollStateChanged(AbsListView absListView, int scroll) {
        this.mScrollStateChangedRunnable.doScrollStateChange(absListView, scroll);
    }

    public void postSetSelection(final int position) {
        this.clearFocus();
        this.post(new Runnable(){

            @Override
            public void run() {
                DayPickerView.this.setSelection(position);
            }
        });
        this.onScrollStateChanged((AbsListView)this, 0);
    }

    protected void setMonthDisplayed(SimpleMonthAdapter.CalendarDay calendarDay) {
        this.mCurrentMonthDisplayed = calendarDay.month;
        this.invalidateViews();
    }

    protected void setUpAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = new SimpleMonthAdapter(this.getContext(), this.mController);
        }
        this.mAdapter.setSelectedDay(this.mSelectedDay);
        this.mAdapter.notifyDataSetChanged();
    }

    protected void setUpListView() {
        this.setCacheColorHint(0);
        this.setDivider(null);
        this.setItemsCanFocus(true);
        this.setFastScrollEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.setOnScrollListener(this);
        this.setFadingEdgeLength(0);
        this.setFrictionIfSupported(ViewConfiguration.getScrollFriction() * this.mFriction);
    }

    @TargetApi(value=11)
    void setFrictionIfSupported(float friction) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.setFriction(friction);
        }
    }

    protected class ScrollStateRunnable
    implements Runnable {
        private int mNewState;

        protected ScrollStateRunnable() {
        }

        public void doScrollStateChange(AbsListView view, int scrollState) {
            DayPickerView.this.mHandler.removeCallbacks((Runnable)this);
            this.mNewState = scrollState;
            DayPickerView.this.mHandler.postDelayed((Runnable)this, 40L);
        }

        @Override
        public void run() {
            DayPickerView.this.mCurrentScrollState = this.mNewState;
            if (this.mNewState == 0 && DayPickerView.this.mPreviousScrollState != 0 && DayPickerView.this.mPreviousScrollState != 1) {
                DayPickerView.this.mPreviousScrollState = this.mNewState;
                int i = 0;
                View child = DayPickerView.this.getChildAt(i);
                while (child != null && child.getBottom() <= 0) {
                    child = DayPickerView.this.getChildAt(++i);
                }
                if (child == null) {
                    return;
                }
                int firstPosition = DayPickerView.this.getFirstVisiblePosition();
                int lastPosition = DayPickerView.this.getLastVisiblePosition();
                boolean scroll = firstPosition != 0 && lastPosition != DayPickerView.this.getCount() - 1;
                int top = child.getTop();
                int bottom = child.getBottom();
                int midpoint = DayPickerView.this.getHeight() / 2;
                if (scroll && top < LIST_TOP_OFFSET) {
                    if (bottom > midpoint) {
                        DayPickerView.this.smoothScrollBy(top, 250);
                    } else {
                        DayPickerView.this.smoothScrollBy(bottom, 250);
                    }
                }
            } else {
                DayPickerView.this.mPreviousScrollState = this.mNewState;
            }
        }
    }
}

