/*
 * Decompiled with CFR 0.152.
 */
package com.fourmob.datetimepicker.date;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.view.MotionEvent;
import android.view.View;
import com.fourmob.datetimepicker.R;
import com.fourmob.datetimepicker.Utils;
import com.fourmob.datetimepicker.date.SimpleMonthAdapter;
import java.security.InvalidParameterException;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;

public class SimpleMonthView
extends View {
    public static final String VIEW_PARAMS_HEIGHT = "height";
    public static final String VIEW_PARAMS_MONTH = "month";
    public static final String VIEW_PARAMS_YEAR = "year";
    public static final String VIEW_PARAMS_SELECTED_DAY = "selected_day";
    public static final String VIEW_PARAMS_WEEK_START = "week_start";
    public static final String VIEW_PARAMS_NUM_DAYS = "num_days";
    public static final String VIEW_PARAMS_FOCUS_MONTH = "focus_month";
    public static final String VIEW_PARAMS_SHOW_WK_NUM = "show_wk_num";
    private static final int SELECTED_CIRCLE_ALPHA = 60;
    protected static int DEFAULT_HEIGHT = 32;
    protected static final int DEFAULT_NUM_ROWS = 6;
    protected static int DAY_SELECTED_CIRCLE_SIZE;
    protected static int DAY_SEPARATOR_WIDTH;
    protected static int MINI_DAY_NUMBER_TEXT_SIZE;
    protected static int MIN_HEIGHT;
    protected static int MONTH_DAY_LABEL_TEXT_SIZE;
    protected static int MONTH_HEADER_SIZE;
    protected static int MONTH_LABEL_TEXT_SIZE;
    protected static float mScale;
    protected int mPadding = 0;
    private String mDayOfWeekTypeface;
    private String mMonthTitleTypeface;
    protected Paint mMonthDayLabelPaint;
    protected Paint mMonthNumPaint;
    protected Paint mMonthTitleBGPaint;
    protected Paint mMonthTitlePaint;
    protected Paint mSelectedCirclePaint;
    protected int mDayTextColor;
    protected int mMonthTitleBGColor;
    protected int mMonthTitleColor;
    protected int mTodayNumberColor;
    private final StringBuilder mStringBuilder;
    private final Formatter mFormatter;
    protected int mFirstJulianDay = -1;
    protected int mFirstMonth = -1;
    protected int mLastMonth = -1;
    protected boolean mHasToday = false;
    protected int mSelectedDay = -1;
    protected int mToday = -1;
    protected int mWeekStart = 1;
    protected int mNumDays;
    protected int mNumCells = this.mNumDays = 7;
    protected int mSelectedLeft = -1;
    protected int mSelectedRight = -1;
    private int mDayOfWeekStart = 0;
    protected int mMonth;
    protected int mRowHeight = DEFAULT_HEIGHT;
    protected int mWidth;
    protected int mYear;
    private final Calendar mCalendar;
    private final Calendar mDayLabelCalendar;
    private int mNumRows = 6;
    private DateFormatSymbols mDateFormatSymbols = new DateFormatSymbols();
    private OnDayClickListener mOnDayClickListener;

    public SimpleMonthView(Context context) {
        super(context);
        Resources resources = context.getResources();
        this.mDayLabelCalendar = Calendar.getInstance();
        this.mCalendar = Calendar.getInstance();
        this.mDayOfWeekTypeface = resources.getString(R.string.day_of_week_label_typeface);
        this.mMonthTitleTypeface = resources.getString(R.string.sans_serif);
        this.mDayTextColor = resources.getColor(R.color.date_picker_text_normal);
        this.mTodayNumberColor = resources.getColor(R.color.blue);
        this.mMonthTitleColor = resources.getColor(R.color.white);
        this.mMonthTitleBGColor = resources.getColor(R.color.circle_background);
        this.mStringBuilder = new StringBuilder(50);
        this.mFormatter = new Formatter(this.mStringBuilder, Locale.getDefault());
        MINI_DAY_NUMBER_TEXT_SIZE = resources.getDimensionPixelSize(R.dimen.day_number_size);
        MONTH_LABEL_TEXT_SIZE = resources.getDimensionPixelSize(R.dimen.month_label_size);
        MONTH_DAY_LABEL_TEXT_SIZE = resources.getDimensionPixelSize(R.dimen.month_day_label_text_size);
        MONTH_HEADER_SIZE = resources.getDimensionPixelOffset(R.dimen.month_list_item_header_height);
        DAY_SELECTED_CIRCLE_SIZE = resources.getDimensionPixelSize(R.dimen.day_number_select_circle_radius);
        this.mRowHeight = (resources.getDimensionPixelOffset(R.dimen.date_picker_view_animator_height) - MONTH_HEADER_SIZE) / 6;
        this.initView();
    }

    private int calculateNumRows() {
        int offset = this.findDayOffset();
        int dividend = (offset + this.mNumCells) / this.mNumDays;
        int remainder = (offset + this.mNumCells) % this.mNumDays;
        return dividend + (remainder > 0 ? 1 : 0);
    }

    private void drawMonthDayLabels(Canvas canvas) {
        int y = MONTH_HEADER_SIZE - MONTH_DAY_LABEL_TEXT_SIZE / 2;
        int dayWidthHalf = (this.mWidth - this.mPadding * 2) / (this.mNumDays * 2);
        for (int i = 0; i < this.mNumDays; ++i) {
            int calendarDay = (i + this.mWeekStart) % this.mNumDays;
            int x = (2 * i + 1) * dayWidthHalf + this.mPadding;
            this.mDayLabelCalendar.set(7, calendarDay);
            canvas.drawText(this.mDateFormatSymbols.getShortWeekdays()[this.mDayLabelCalendar.get(7)].toUpperCase(Locale.getDefault()), (float)x, (float)y, this.mMonthDayLabelPaint);
        }
    }

    private void drawMonthTitle(Canvas canvas) {
        int x = (this.mWidth + 2 * this.mPadding) / 2;
        int y = (MONTH_HEADER_SIZE - MONTH_DAY_LABEL_TEXT_SIZE) / 2 + MONTH_LABEL_TEXT_SIZE / 3;
        canvas.drawText(this.getMonthAndYearString(), (float)x, (float)y, this.mMonthTitlePaint);
    }

    private int findDayOffset() {
        return (this.mDayOfWeekStart < this.mWeekStart ? this.mDayOfWeekStart + this.mNumDays : this.mDayOfWeekStart) - this.mWeekStart;
    }

    private String getMonthAndYearString() {
        int flags = 52;
        this.mStringBuilder.setLength(0);
        long millis = this.mCalendar.getTimeInMillis();
        return DateUtils.formatDateRange((Context)this.getContext(), (long)millis, (long)millis, (int)flags);
    }

    private void onDayClick(SimpleMonthAdapter.CalendarDay calendarDay) {
        if (this.mOnDayClickListener != null) {
            this.mOnDayClickListener.onDayClick(this, calendarDay);
        }
    }

    private boolean sameDay(int monthDay, Time time) {
        return this.mYear == time.year && this.mMonth == time.month && monthDay == time.monthDay;
    }

    protected void drawMonthNums(Canvas canvas) {
        int y = (this.mRowHeight + MINI_DAY_NUMBER_TEXT_SIZE) / 2 - DAY_SEPARATOR_WIDTH + MONTH_HEADER_SIZE;
        int paddingDay = (this.mWidth - 2 * this.mPadding) / (2 * this.mNumDays);
        int dayOffset = this.findDayOffset();
        for (int day = 1; day <= this.mNumCells; ++day) {
            int x = paddingDay * (1 + dayOffset * 2) + this.mPadding;
            if (this.mSelectedDay == day) {
                canvas.drawCircle((float)x, (float)(y - MINI_DAY_NUMBER_TEXT_SIZE / 3), (float)DAY_SELECTED_CIRCLE_SIZE, this.mSelectedCirclePaint);
            }
            if (this.mHasToday && this.mToday == day) {
                this.mMonthNumPaint.setColor(this.mTodayNumberColor);
            } else {
                this.mMonthNumPaint.setColor(this.mDayTextColor);
            }
            canvas.drawText(String.format("%d", day), (float)x, (float)y, this.mMonthNumPaint);
            if (++dayOffset != this.mNumDays) continue;
            dayOffset = 0;
            y += this.mRowHeight;
        }
    }

    public SimpleMonthAdapter.CalendarDay getDayFromLocation(float x, float y) {
        int padding = this.mPadding;
        if (x < (float)padding || x > (float)(this.mWidth - this.mPadding)) {
            return null;
        }
        int yDay = (int)(y - (float)MONTH_HEADER_SIZE) / this.mRowHeight;
        int day = 1 + ((int)((x - (float)padding) * (float)this.mNumDays / (float)(this.mWidth - padding - this.mPadding)) - this.findDayOffset()) + yDay * this.mNumDays;
        return new SimpleMonthAdapter.CalendarDay(this.mYear, this.mMonth, day);
    }

    protected void initView() {
        this.mMonthTitlePaint = new Paint();
        this.mMonthTitlePaint.setFakeBoldText(true);
        this.mMonthTitlePaint.setAntiAlias(true);
        this.mMonthTitlePaint.setTextSize((float)MONTH_LABEL_TEXT_SIZE);
        this.mMonthTitlePaint.setTypeface(Typeface.create((String)this.mMonthTitleTypeface, (int)1));
        this.mMonthTitlePaint.setColor(this.mDayTextColor);
        this.mMonthTitlePaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthTitlePaint.setStyle(Paint.Style.FILL);
        this.mMonthTitleBGPaint = new Paint();
        this.mMonthTitleBGPaint.setFakeBoldText(true);
        this.mMonthTitleBGPaint.setAntiAlias(true);
        this.mMonthTitleBGPaint.setColor(this.mMonthTitleBGColor);
        this.mMonthTitleBGPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthTitleBGPaint.setStyle(Paint.Style.FILL);
        this.mSelectedCirclePaint = new Paint();
        this.mSelectedCirclePaint.setFakeBoldText(true);
        this.mSelectedCirclePaint.setAntiAlias(true);
        this.mSelectedCirclePaint.setColor(this.mTodayNumberColor);
        this.mSelectedCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mSelectedCirclePaint.setStyle(Paint.Style.FILL);
        this.mSelectedCirclePaint.setAlpha(60);
        this.mMonthDayLabelPaint = new Paint();
        this.mMonthDayLabelPaint.setAntiAlias(true);
        this.mMonthDayLabelPaint.setTextSize((float)MONTH_DAY_LABEL_TEXT_SIZE);
        this.mMonthDayLabelPaint.setColor(this.mDayTextColor);
        this.mMonthDayLabelPaint.setTypeface(Typeface.create((String)this.mDayOfWeekTypeface, (int)0));
        this.mMonthDayLabelPaint.setStyle(Paint.Style.FILL);
        this.mMonthDayLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthDayLabelPaint.setFakeBoldText(true);
        this.mMonthNumPaint = new Paint();
        this.mMonthNumPaint.setAntiAlias(true);
        this.mMonthNumPaint.setTextSize((float)MINI_DAY_NUMBER_TEXT_SIZE);
        this.mMonthNumPaint.setStyle(Paint.Style.FILL);
        this.mMonthNumPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthNumPaint.setFakeBoldText(false);
    }

    protected void onDraw(Canvas canvas) {
        this.drawMonthTitle(canvas);
        this.drawMonthDayLabels(canvas);
        this.drawMonthNums(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), this.mRowHeight * this.mNumRows + MONTH_HEADER_SIZE);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mWidth = w;
    }

    public boolean onTouchEvent(MotionEvent event) {
        SimpleMonthAdapter.CalendarDay calendarDay;
        if (event.getAction() == 1 && (calendarDay = this.getDayFromLocation(event.getX(), event.getY())) != null) {
            this.onDayClick(calendarDay);
        }
        return true;
    }

    public void reuse() {
        this.mNumRows = 6;
        this.requestLayout();
    }

    public void setMonthParams(HashMap<String, Integer> params) {
        if (!params.containsKey(VIEW_PARAMS_MONTH) && !params.containsKey(VIEW_PARAMS_YEAR)) {
            throw new InvalidParameterException("You must specify month and year for this view");
        }
        this.setTag(params);
        if (params.containsKey(VIEW_PARAMS_HEIGHT)) {
            this.mRowHeight = params.get(VIEW_PARAMS_HEIGHT);
            if (this.mRowHeight < MIN_HEIGHT) {
                this.mRowHeight = MIN_HEIGHT;
            }
        }
        if (params.containsKey(VIEW_PARAMS_SELECTED_DAY)) {
            this.mSelectedDay = params.get(VIEW_PARAMS_SELECTED_DAY);
        }
        this.mMonth = params.get(VIEW_PARAMS_MONTH);
        this.mYear = params.get(VIEW_PARAMS_YEAR);
        Time today = new Time(Time.getCurrentTimezone());
        today.setToNow();
        this.mHasToday = false;
        this.mToday = -1;
        this.mCalendar.set(2, this.mMonth);
        this.mCalendar.set(1, this.mYear);
        this.mCalendar.set(5, 1);
        this.mDayOfWeekStart = this.mCalendar.get(7);
        this.mWeekStart = params.containsKey(VIEW_PARAMS_WEEK_START) ? params.get(VIEW_PARAMS_WEEK_START).intValue() : this.mCalendar.getFirstDayOfWeek();
        this.mNumCells = Utils.getDaysInMonth(this.mMonth, this.mYear);
        for (int i = 0; i < this.mNumCells; ++i) {
            int day = i + 1;
            if (!this.sameDay(day, today)) continue;
            this.mHasToday = true;
            this.mToday = day;
        }
        this.mNumRows = this.calculateNumRows();
    }

    public void setOnDayClickListener(OnDayClickListener onDayClickListener) {
        this.mOnDayClickListener = onDayClickListener;
    }

    static {
        DAY_SEPARATOR_WIDTH = 1;
        MIN_HEIGHT = 10;
        mScale = 0.0f;
    }

    public static interface OnDayClickListener {
        public void onDayClick(SimpleMonthView var1, SimpleMonthAdapter.CalendarDay var2);
    }
}

