/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluidsonic.fluid.json;

import com.github.fluidsonic.fluid.json.JSONException;
import com.github.fluidsonic.fluid.json.JSONWriterKt;
import com.github.fluidsonic.fluid.json.StandardWriter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.Writer;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\bf\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"J\b\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0004H&J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\rH&J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0007H&J\b\u0010\u0013\u001a\u00020\u0007H&J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0015H&J\b\u0010\u0016\u001a\u00020\u0007H&J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0007H&J\b\u0010\u001a\u001a\u00020\u0007H&J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0018H&J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\t\u001a\u00020!H\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006#"}, d2={"Lcom/github/fluidsonic/fluid/json/JSONWriter;", "Ljava/io/Closeable;", "Ljava/io/Flushable;", "isErrored", "", "()Z", "markAsErrored", "", "writeBoolean", "value", "writeByte", "", "writeDouble", "", "writeFloat", "", "writeInt", "", "writeListEnd", "writeListStart", "writeLong", "", "writeMapEnd", "writeMapKey", "", "writeMapStart", "writeNull", "writeNumber", "", "writeShort", "", "writeString", "writeValue", "", "Companion", "fluid-json"})
public interface JSONWriter
extends Closeable,
Flushable {
    public static final Companion Companion = new Companion(null);

    public boolean isErrored();

    public void markAsErrored();

    public void writeBoolean(boolean var1);

    public void writeDouble(double var1);

    public void writeListEnd();

    public void writeListStart();

    public void writeLong(long var1);

    public void writeMapEnd();

    public void writeMapStart();

    public void writeNull();

    public void writeString(@NotNull String var1);

    public void writeByte(byte var1);

    public void writeFloat(float var1);

    public void writeInt(int var1);

    public void writeMapKey(@NotNull String var1);

    public void writeNumber(@NotNull Number var1);

    public void writeShort(short var1);

    public void writeValue(@NotNull Object var1);

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=3)
    public static final class DefaultImpls {
        public static void writeByte(JSONWriter $this, byte value) {
            $this.writeLong(value);
        }

        public static void writeFloat(JSONWriter $this, float value) {
            $this.writeDouble(value);
        }

        public static void writeInt(JSONWriter $this, int value) {
            $this.writeLong(value);
        }

        public static void writeMapKey(@NotNull JSONWriter $this, String value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            $this.writeString(value);
        }

        public static void writeNumber(@NotNull JSONWriter $this, Number value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Number number = value;
            if (number instanceof Byte) {
                $this.writeByte(value.byteValue());
            } else if (number instanceof Float) {
                $this.writeFloat(value.floatValue());
            } else if (number instanceof Integer) {
                $this.writeInt(value.intValue());
            } else if (number instanceof Long) {
                $this.writeLong(value.longValue());
            } else if (number instanceof Short) {
                $this.writeShort(value.shortValue());
            } else {
                $this.writeDouble(value.doubleValue());
            }
        }

        public static void writeShort(JSONWriter $this, short value) {
            $this.writeLong(value);
        }

        public static void writeValue(@NotNull JSONWriter $this, Object value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Object object = value;
            if (object instanceof Object[]) {
                JSONWriterKt.writeList($this, (Object[])value);
            } else if (object instanceof Boolean) {
                $this.writeBoolean((Boolean)value);
            } else if (object instanceof boolean[]) {
                JSONWriterKt.writeList($this, (boolean[])value);
            } else if (object instanceof Byte) {
                $this.writeByte(((Number)value).byteValue());
            } else if (object instanceof byte[]) {
                JSONWriterKt.writeList($this, (byte[])value);
            } else if (object instanceof double[]) {
                JSONWriterKt.writeList($this, (double[])value);
            } else if (object instanceof Float) {
                $this.writeFloat(((Number)value).floatValue());
            } else if (object instanceof float[]) {
                JSONWriterKt.writeList($this, (float[])value);
            } else if (object instanceof Integer) {
                $this.writeInt(((Number)value).intValue());
            } else if (object instanceof int[]) {
                JSONWriterKt.writeList($this, (int[])value);
            } else if (object instanceof Iterable) {
                JSONWriterKt.writeList($this, (Iterable)value);
            } else if (object instanceof Long) {
                $this.writeLong(((Number)value).longValue());
            } else if (object instanceof long[]) {
                JSONWriterKt.writeList($this, (long[])value);
            } else if (object instanceof Map) {
                JSONWriterKt.writeMap($this, (Map)value);
            } else if (object instanceof Sequence) {
                JSONWriterKt.writeList($this, (Sequence)value);
            } else if (object instanceof Short) {
                $this.writeShort(((Number)value).shortValue());
            } else if (object instanceof short[]) {
                JSONWriterKt.writeList($this, (short[])value);
            } else if (object instanceof String) {
                $this.writeString((String)value);
            } else if (object instanceof Number) {
                $this.writeNumber((Number)value);
            } else {
                throw (Throwable)new JSONException("Cannot write JSON value of " + Reflection.getOrCreateKotlinClass(value.getClass()) + ": " + value, null, 2, null);
            }
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/fluidsonic/fluid/json/JSONWriter$Companion;", "", "()V", "build", "Lcom/github/fluidsonic/fluid/json/JSONWriter;", "destination", "Ljava/io/Writer;", "fluid-json"})
    public static final class Companion {
        @NotNull
        public final JSONWriter build(@NotNull Writer destination) {
            Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
            return new StandardWriter(destination);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

