/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluidsonic.fluid.json;

import com.github.fluidsonic.fluid.json.JSONException;
import com.github.fluidsonic.fluid.json.JSONReader$WhenMappings;
import com.github.fluidsonic.fluid.json.JSONReaderKt;
import com.github.fluidsonic.fluid.json.JSONToken;
import com.github.fluidsonic.fluid.json.StandardReader;
import com.github.fluidsonic.fluid.json.TextInput;
import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\bf\u0018\u0000 #2\u00020\u0001:\u0001#J\b\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH&J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H&J\b\u0010\u0012\u001a\u00020\u0011H&J\b\u0010\u0013\u001a\u00020\u0014H&J\b\u0010\u0015\u001a\u00020\u0011H&J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0011H&J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH&J\b\u0010\u001b\u001a\u00020\u001cH&J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0017H&J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0011H\u0016R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006$"}, d2={"Lcom/github/fluidsonic/fluid/json/JSONReader;", "Ljava/io/Closeable;", "nextToken", "Lcom/github/fluidsonic/fluid/json/JSONToken;", "getNextToken", "()Lcom/github/fluidsonic/fluid/json/JSONToken;", "readBoolean", "", "readByte", "", "readDouble", "", "readFloat", "", "readInt", "", "readListEnd", "", "readListStart", "readLong", "", "readMapEnd", "readMapKey", "", "readMapStart", "readNull", "", "readNumber", "", "readShort", "", "readString", "readValue", "", "skipValue", "Companion", "fluid-json"})
public interface JSONReader
extends Closeable {
    public static final Companion Companion = com.github.fluidsonic.fluid.json.JSONReader$Companion.$$INSTANCE;

    @Nullable
    public JSONToken getNextToken();

    public boolean readBoolean();

    public double readDouble();

    public void readListEnd();

    public void readListStart();

    public long readLong();

    public void readMapEnd();

    public void readMapStart();

    @Nullable
    public Void readNull();

    @NotNull
    public Number readNumber();

    @NotNull
    public String readString();

    public byte readByte();

    public float readFloat();

    public int readInt();

    @NotNull
    public String readMapKey();

    public short readShort();

    @NotNull
    public Object readValue();

    public void skipValue();

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static byte readByte(JSONReader $this) {
            long value = $this.readLong();
            return (byte)(value >= (long)127 ? 127 : (byte)(value <= (long)-128 ? -128 : (byte)value));
        }

        public static float readFloat(JSONReader $this) {
            return (float)$this.readDouble();
        }

        public static int readInt(JSONReader $this) {
            long value = $this.readLong();
            return value >= (long)Integer.MAX_VALUE ? Integer.MAX_VALUE : (value <= (long)Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)value);
        }

        @NotNull
        public static String readMapKey(JSONReader $this) {
            return $this.readString();
        }

        public static short readShort(JSONReader $this) {
            long value = $this.readLong();
            return (short)(value >= (long)Short.MAX_VALUE ? Short.MAX_VALUE : (short)(value <= (long)Short.MIN_VALUE ? Short.MIN_VALUE : (short)value));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public static Object readValue(JSONReader $this) {
            JSONToken token;
            JSONToken jSONToken = token = $this.getNextToken();
            if (jSONToken == null) throw (Throwable)new JSONException("Cannot read value. Current token is '" + (Object)((Object)token) + '\'', null, 2, null);
            switch (JSONReader$WhenMappings.$EnumSwitchMapping$0[jSONToken.ordinal()]) {
                case 1: {
                    Object object = $this.readBoolean();
                    return object;
                }
                case 2: {
                    Object object = JSONReaderKt.readList($this);
                    return object;
                }
                case 3: {
                    Object object = $this.readMapKey();
                    return object;
                }
                case 4: {
                    Object object = JSONReaderKt.readMap($this);
                    return object;
                }
                case 5: {
                    Object object = $this.readNumber();
                    return object;
                }
                case 6: {
                    Object object = $this.readString();
                    return object;
                }
                default: {
                    throw (Throwable)new JSONException("Cannot read value. Current token is '" + (Object)((Object)token) + '\'', null, 2, null);
                }
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void skipValue(JSONReader $this) {
            JSONToken token;
            JSONToken jSONToken = token = $this.getNextToken();
            if (jSONToken == null) throw (Throwable)new JSONException("Cannot skip value if next token is '" + (Object)((Object)token) + '\'', null, 2, null);
            switch (JSONReader$WhenMappings.$EnumSwitchMapping$1[jSONToken.ordinal()]) {
                case 1: {
                    $this.readBoolean();
                    return;
                }
                case 2: {
                    JSONReader $receiver$iv$iv;
                    List list;
                    JSONReader $receiver$iv = $this;
                    List list$iv = list = (List)new ArrayList();
                    JSONReader $receiver$iv$iv$iv = $receiver$iv$iv = $receiver$iv;
                    $receiver$iv$iv$iv.readListStart();
                    JSONReader $receiver$iv$iv2 = $receiver$iv$iv$iv;
                    while ($receiver$iv$iv2.getNextToken() != JSONToken.listEnd) {
                        JSONReader $receiver$iv2 = $receiver$iv$iv2;
                        Collection collection = list$iv;
                        JSONReader $receiver = $receiver$iv2;
                        $receiver.skipValue();
                        Unit unit = Unit.INSTANCE;
                        collection.add(unit);
                    }
                    Unit value$iv$iv$iv = Unit.INSTANCE;
                    $receiver$iv$iv$iv.readListEnd();
                    return;
                }
                case 3: {
                    $this.readMapKey();
                    return;
                }
                case 4: {
                    JSONReader $receiver$iv$iv;
                    Map map;
                    JSONReader $receiver$iv = $this;
                    Map map$iv = map = (Map)new LinkedHashMap();
                    JSONReader $receiver$iv$iv$iv = $receiver$iv$iv = $receiver$iv;
                    $receiver$iv$iv$iv.readMapStart();
                    JSONReader $receiver$iv$iv3 = $receiver$iv$iv$iv;
                    while ($receiver$iv$iv3.getNextToken() != JSONToken.mapEnd) {
                        void key$iv;
                        String $receiver$iv2 = $receiver$iv$iv3.readMapKey();
                        JSONReader $receiver$iv3 = $receiver$iv$iv3;
                        Map map2 = map$iv;
                        void $i$a$1$readListByElement = key$iv;
                        JSONReader $receiver = $receiver$iv3;
                        $receiver.skipValue();
                        Unit unit = Unit.INSTANCE;
                        map2.put(key$iv, unit);
                    }
                    Unit result$iv$iv$iv = Unit.INSTANCE;
                    $receiver$iv$iv$iv.readMapEnd();
                    return;
                }
                case 5: {
                    $this.readNull();
                    return;
                }
                case 6: {
                    $this.readNumber();
                    return;
                }
                case 7: {
                    $this.readString();
                    return;
                }
                default: {
                    throw (Throwable)new JSONException("Cannot skip value if next token is '" + (Object)((Object)token) + '\'', null, 2, null);
                }
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/github/fluidsonic/fluid/json/JSONReader$Companion;", "", "()V", "build", "Lcom/github/fluidsonic/fluid/json/JSONReader;", "source", "Ljava/io/Reader;", "", "fluid-json"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final JSONReader build(@NotNull Reader source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            return new StandardReader(new TextInput(source));
        }

        @NotNull
        public final JSONReader build(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            return this.build(new StringReader(source));
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

