/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluidsonic.fluid.json;

import com.github.fluidsonic.fluid.json.AbstractJSONDecoderCodec;
import com.github.fluidsonic.fluid.json.JSONCodableType;
import com.github.fluidsonic.fluid.json.JSONCoderContext;
import com.github.fluidsonic.fluid.json.JSONDecoder;
import com.github.fluidsonic.fluid.json.JSONDecoderCodec;
import com.github.fluidsonic.fluid.json.JSONException;
import com.github.fluidsonic.fluid.json.JSONToken;
import com.github.fluidsonic.fluid.json.NonRecursiveParser;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000 \u000e*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0005J+\u0010\b\u001a\u00028\u00002\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0016\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/fluidsonic/fluid/json/NonRecursiveJSONDecoderCodec;", "Value", "", "Lcom/github/fluidsonic/fluid/json/AbstractJSONDecoderCodec;", "Lcom/github/fluidsonic/fluid/json/JSONCoderContext;", "()V", "expectedFirstToken", "Lcom/github/fluidsonic/fluid/json/JSONToken;", "decode", "valueType", "Lcom/github/fluidsonic/fluid/json/JSONCodableType;", "decoder", "Lcom/github/fluidsonic/fluid/json/JSONDecoder;", "(Lcom/github/fluidsonic/fluid/json/JSONCodableType;Lcom/github/fluidsonic/fluid/json/JSONDecoder;)Ljava/lang/Object;", "Companion", "fluid-json"})
public abstract class NonRecursiveJSONDecoderCodec<Value>
extends AbstractJSONDecoderCodec<Value, JSONCoderContext> {
    private final JSONToken expectedFirstToken;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Value decode(@NotNull JSONCodableType<? super Value> valueType, @NotNull JSONDecoder<? extends JSONCoderContext> decoder) {
        Object object;
        Intrinsics.checkParameterIsNotNull(valueType, (String)"valueType");
        Intrinsics.checkParameterIsNotNull(decoder, (String)"decoder");
        if (decoder.getNextToken() != this.expectedFirstToken) {
            throw (Throwable)new JSONException("Cannot decode " + (Object)((Object)decoder.getNextToken()) + " as " + valueType, null, 2, null);
        }
        Object value = NonRecursiveParser.INSTANCE.parse(decoder);
        if (Intrinsics.areEqual(valueType.getRawClass(), (Object)Reflection.getOrCreateKotlinClass(Sequence.class))) {
            Object object2 = value;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Iterable<*>");
            }
            Sequence sequence = CollectionsKt.asSequence((Iterable)((Iterable)object2));
            if (sequence == null) {
                throw new TypeCastException("null cannot be cast to non-null type Value");
            }
            object = sequence;
        } else {
            object = value;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type Value");
            }
        }
        return (Value)object;
    }

    public NonRecursiveJSONDecoderCodec() {
        super(null, 1, null);
        JSONToken jSONToken;
        KClass kClass = this.getDecodableType().getRawClass();
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Iterable.class)) || Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(List.class)) || Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Sequence.class))) {
            jSONToken = JSONToken.listStart;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Map.class))) {
            jSONToken = JSONToken.mapStart;
        } else {
            String string = "Cannot decode " + this.getDecodableType();
            NonRecursiveJSONDecoderCodec nonRecursiveJSONDecoderCodec = this;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.expectedFirstToken = jSONToken;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00060\u0004\"\n\b\u0001\u0010\u0005\u0018\u0001*\u00020\u0001H\u0086\b\u00a8\u0006\u0007"}, d2={"Lcom/github/fluidsonic/fluid/json/NonRecursiveJSONDecoderCodec$Companion;", "", "()V", "create", "Lcom/github/fluidsonic/fluid/json/JSONDecoderCodec;", "Value", "Lcom/github/fluidsonic/fluid/json/JSONCoderContext;", "fluid-json"})
    public static final class Companion {
        private final <Value> JSONDecoderCodec<Value, JSONCoderContext> create() {
            Intrinsics.needClassReification();
            return new NonRecursiveJSONDecoderCodec<Value>(){};
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

