/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluidsonic.fluid.json;

import com.github.fluidsonic.fluid.json.JSONReader;
import com.github.fluidsonic.fluid.json.JSONToken;
import com.github.fluidsonic.fluid.json.NonRecursiveParser$WhenMappings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/github/fluidsonic/fluid/json/NonRecursiveParser;", "", "()V", "parse", "source", "Lcom/github/fluidsonic/fluid/json/JSONReader;", "fluid-json"})
public final class NonRecursiveParser {
    public static final NonRecursiveParser INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Object parse(@NotNull JSONReader source) {
        Object value;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        List currentList = null;
        String currentKey = null;
        Map currentMap = null;
        List parents = new ArrayList();
        List parentKeys = new ArrayList();
        block11: while (true) {
            Object object;
            JSONToken jSONToken = source.getNextToken();
            if (jSONToken == null) throw (Throwable)new IllegalStateException("reader is messed up");
            switch (NonRecursiveParser$WhenMappings.$EnumSwitchMapping$0[jSONToken.ordinal()]) {
                case 1: {
                    object = source.readBoolean();
                    break;
                }
                case 2: {
                    Object parent;
                    source.readListEnd();
                    List list = currentList;
                    int parentCount = parents.size();
                    if (parentCount > 0) {
                        parent = parents.remove(parentCount - 1);
                        if (TypeIntrinsics.isMutableList(parent)) {
                            Object e = parent;
                            if (e == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Any?>");
                            }
                            currentList = TypeIntrinsics.asMutableList(e);
                        } else {
                            currentList = null;
                            Object e = parent;
                            if (e == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.Any?, kotlin.Any?>");
                            }
                            currentMap = TypeIntrinsics.asMutableMap(e);
                        }
                    } else {
                        currentList = null;
                        currentMap = null;
                    }
                    object = list;
                    break;
                }
                case 3: {
                    source.readListStart();
                    List list = new ArrayList();
                    if (currentList != null) {
                        Collection parentCount = parents;
                        parentCount.add(currentList);
                    } else if (currentMap != null) {
                        Collection parentCount = parents;
                        parentCount.add(currentMap);
                        currentMap = null;
                    }
                    currentList = list;
                    continue block11;
                }
                case 4: {
                    object = source.readNull();
                    break;
                }
                case 5: {
                    Object parent;
                    source.readMapEnd();
                    Map map = currentMap;
                    int parentCount = parents.size();
                    if (parentCount > 0) {
                        parent = parents.remove(parentCount - 1);
                        if (TypeIntrinsics.isMutableMap(parent)) {
                            Object e = parent;
                            if (e == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.Any?, kotlin.Any?>");
                            }
                            currentMap = TypeIntrinsics.asMutableMap(e);
                        } else {
                            Object e = parent;
                            if (e == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Any?>");
                            }
                            currentList = TypeIntrinsics.asMutableList(e);
                            currentMap = null;
                        }
                    } else {
                        currentList = null;
                        currentMap = null;
                    }
                    int parentKeyCount = parentKeys.size();
                    if (parentKeyCount > 0) {
                        currentKey = (String)parentKeys.remove(parentKeyCount - 1);
                    }
                    object = map;
                    break;
                }
                case 6: {
                    currentKey = source.readMapKey();
                    continue block11;
                }
                case 7: {
                    source.readMapStart();
                    Map map = new LinkedHashMap();
                    if (currentMap != null) {
                        Collection collection = parents;
                        collection.add(currentMap);
                    } else if (currentList != null) {
                        Collection collection = parents;
                        collection.add(currentList);
                        currentList = null;
                    }
                    if (currentKey != null) {
                        Collection collection = parentKeys;
                        collection.add(currentKey);
                        currentKey = null;
                    }
                    currentMap = map;
                    continue block11;
                }
                case 8: {
                    object = source.readNumber();
                    break;
                }
                case 9: {
                    object = source.readString();
                    break;
                }
                default: {
                    throw (Throwable)new IllegalStateException("reader is messed up");
                }
            }
            value = object;
            if (currentList != null) {
                currentList.add(value);
                continue;
            }
            if (currentMap == null) break;
            Map map = currentMap;
            Object object2 = value;
            map.put(currentKey, object2);
        }
        Object object = value;
        if (object != null) return object;
        throw (Throwable)new IllegalStateException("reader is messed up");
    }

    private NonRecursiveParser() {
    }

    static {
        NonRecursiveParser nonRecursiveParser;
        INSTANCE = nonRecursiveParser = new NonRecursiveParser();
    }
}

