/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluidsonic.fluid.json;

import com.github.fluidsonic.fluid.json.JSONException;
import com.github.fluidsonic.fluid.json.JSONWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.ArrayIteratorsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/github/fluidsonic/fluid/json/NonRecursiveSerializer;", "", "()V", "serialize", "", "rootValue", "destination", "Lcom/github/fluidsonic/fluid/json/JSONWriter;", "fluid-json"})
public final class NonRecursiveSerializer {
    public static final NonRecursiveSerializer INSTANCE;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void serialize(@Nullable Object rootValue, @NotNull JSONWriter destination) {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Iterator currentIterator = null;
        Iterator<Object> currentValue = rootValue;
        boolean isInMap = false;
        List iteratorStack = new ArrayList();
        List isInMapStack = new ArrayList();
        boolean isInMapElementValue = false;
        do {
            Iterator iterator;
            if (!isInMapElementValue && currentIterator != null) {
                if (currentIterator.hasNext()) {
                    currentValue = currentIterator.next();
                } else {
                    if (isInMap) {
                        destination.writeMapEnd();
                    } else {
                        destination.writeListEnd();
                    }
                    int iteratorStackSize = iteratorStack.size();
                    if (iteratorStackSize <= 0) return;
                    currentIterator = (Iterator)iteratorStack.remove(iteratorStackSize - 1);
                    isInMap = (Boolean)isInMapStack.remove(isInMapStack.size() - 1);
                    continue;
                }
            }
            if ((iterator = (currentValue = (iterator = currentValue) instanceof Map ? currentValue : (iterator instanceof Iterable ? ((Iterable)((Object)currentValue)).iterator() : (iterator instanceof Sequence ? ((Sequence)currentValue).iterator() : (iterator instanceof Object[] ? ArrayIteratorKt.iterator((Object[])((Object[])currentValue)) : (iterator instanceof boolean[] ? ArrayIteratorsKt.iterator((boolean[])((boolean[])currentValue)) : (iterator instanceof byte[] ? ArrayIteratorsKt.iterator((byte[])((byte[])currentValue)) : (iterator instanceof double[] ? ArrayIteratorsKt.iterator((double[])((double[])currentValue)) : (iterator instanceof float[] ? ArrayIteratorsKt.iterator((float[])((float[])currentValue)) : (iterator instanceof int[] ? ArrayIteratorsKt.iterator((int[])((int[])currentValue)) : (iterator instanceof long[] ? ArrayIteratorsKt.iterator((long[])((long[])currentValue)) : (iterator instanceof short[] ? ArrayIteratorsKt.iterator((short[])((short[])currentValue)) : currentValue)))))))))))) == null) {
                destination.writeNull();
            } else if (iterator instanceof Boolean) {
                destination.writeBoolean((Boolean)((Object)currentValue));
            } else if (iterator instanceof Byte) {
                destination.writeByte(((Number)((Object)currentValue)).byteValue());
            } else if (iterator instanceof Double) {
                double d = ((Number)((Object)currentValue)).doubleValue();
                double d2 = d;
                if (!(!Double.isInfinite(d2) && !Double.isNaN(d2 = d))) throw (Throwable)new JSONException("Cannot serialize double value '" + currentValue + '\'', null, 2, null);
                destination.writeDouble(((Number)((Object)currentValue)).doubleValue());
            } else if (iterator instanceof Float) {
                float f = ((Number)((Object)currentValue)).floatValue();
                float f2 = f;
                if (!(!Float.isInfinite(f2) && !Float.isNaN(f2 = f))) throw (Throwable)new JSONException("Cannot serialize float value '" + currentValue + '\'', null, 2, null);
                destination.writeFloat(((Number)((Object)currentValue)).floatValue());
            } else if (iterator instanceof Integer) {
                destination.writeInt(((Number)((Object)currentValue)).intValue());
            } else if (iterator instanceof Iterator) {
                if (currentIterator != null) {
                    Collection collection = iteratorStack;
                    collection.add(currentIterator);
                }
                Collection collection = isInMapStack;
                Boolean bl = isInMap;
                collection.add(bl);
                currentIterator = currentValue;
                isInMap = false;
                destination.writeListStart();
            } else if (iterator instanceof Long) {
                destination.writeLong(((Number)((Object)currentValue)).longValue());
            } else if (iterator instanceof Short) {
                destination.writeShort(((Number)((Object)currentValue)).shortValue());
            } else if (iterator instanceof String) {
                destination.writeString((String)((Object)currentValue));
            } else if (iterator instanceof Map) {
                if (currentIterator != null) {
                    Collection collection = iteratorStack;
                    collection.add(currentIterator);
                }
                Object object = isInMapStack;
                Boolean bl = isInMap;
                object.add(bl);
                object = (Map)((Object)currentValue);
                currentIterator = object.entrySet().iterator();
                isInMap = true;
                destination.writeMapStart();
            } else {
                if (iterator instanceof Map.Entry) {
                    void elementKey;
                    Map.Entry entry;
                    if (!isInMap || isInMapElementValue) throw (Throwable)new JSONException("Cannot serialize value of " + Reflection.getOrCreateKotlinClass(currentValue.getClass()) + ": " + currentValue, null, 2, null);
                    Map.Entry entry2 = entry = (Map.Entry)((Object)currentValue);
                    Object k = entry2.getKey();
                    entry2 = entry;
                    Object elementValue = entry2.getValue();
                    entry = elementKey;
                    if (!(entry instanceof String)) {
                        throw (Throwable)new JSONException("Cannot serialize non-String key of " + Reflection.getOrCreateKotlinClass(currentValue.getClass()) + ": " + currentValue, null, 2, null);
                    }
                    destination.writeMapKey((String)elementKey);
                    currentValue = elementValue;
                    isInMapElementValue = true;
                    continue;
                }
                if (!(iterator instanceof Number)) throw (Throwable)new JSONException("Cannot serialize value of " + Reflection.getOrCreateKotlinClass(currentValue.getClass()) + ": " + currentValue, null, 2, null);
                destination.writeNumber((Number)((Object)currentValue));
            }
            isInMapElementValue = false;
        } while (currentIterator != null);
    }

    private NonRecursiveSerializer() {
    }

    static {
        NonRecursiveSerializer nonRecursiveSerializer;
        INSTANCE = nonRecursiveSerializer = new NonRecursiveSerializer();
    }
}

