/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluidsonic.fluid.json;

import com.github.fluidsonic.fluid.json.Character;
import com.github.fluidsonic.fluid.json.JSONException;
import com.github.fluidsonic.fluid.json.JSONReader;
import com.github.fluidsonic.fluid.json.JSONToken;
import com.github.fluidsonic.fluid.json.StandardReader$WhenMappings;
import com.github.fluidsonic.fluid.json.TextInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0004\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001:B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0014H\u0016J\b\u0010\"\u001a\u00020\u0014H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0002J\b\u0010&\u001a\u00020\u0014H\u0016J\b\u0010'\u001a\u00020\u0014H\u0016J\n\u0010(\u001a\u0004\u0018\u00010)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u001cH\u0002J\b\u0010-\u001a\u00020\u001aH\u0016J\b\u0010.\u001a\u00020\u001aH\u0002J\u0010\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020\tH\u0002J\u0018\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\tH\u0002J\b\u00102\u001a\u00020\u0014H\u0002J\b\u00103\u001a\u00020\u0014H\u0002J\"\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u00107\u001a\u00020\u000eH\u0002J\u0010\u00108\u001a\u00020\u00142\u0006\u00109\u001a\u00020\tH\u0002R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/github/fluidsonic/fluid/json/StandardReader;", "Lcom/github/fluidsonic/fluid/json/JSONReader;", "source", "Lcom/github/fluidsonic/fluid/json/TextInput;", "(Lcom/github/fluidsonic/fluid/json/TextInput;)V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "nextToken", "Lcom/github/fluidsonic/fluid/json/JSONToken;", "getNextToken", "()Lcom/github/fluidsonic/fluid/json/JSONToken;", "peekedToken", "peekedTokenIndex", "", "state", "Lcom/github/fluidsonic/fluid/json/StandardReader$State;", "stateStack", "", "assertNotClosed", "", "close", "finishValue", "peekToken", "peekValueToken", "expected", "", "readBoolean", "", "readDouble", "", "readFloat", "", "readListEnd", "readListStart", "readLong", "", "readLongLocked", "readMapEnd", "readMapStart", "readNull", "", "readNumber", "", "readNumberIntoBuffer", "readString", "readStringLocked", "readToken", "required", "alternative", "restoreState", "saveState", "unexpectedCharacter", "Lcom/github/fluidsonic/fluid/json/JSONException;", "character", "characterIndex", "unreadToken", "token", "State", "fluid-json"})
public final class StandardReader
implements JSONReader {
    private final StringBuilder buffer;
    private JSONToken peekedToken;
    private int peekedTokenIndex;
    private State state;
    private final List<State> stateStack;
    private final TextInput source;

    private final void assertNotClosed() {
        if (this.state == State.closed) {
            throw (Throwable)new IOException("Cannot operate on a closed reader");
        }
    }

    @Override
    public void close() {
        if (this.state == State.closed) {
            return;
        }
        this.state = State.closed;
        this.source.close();
    }

    private final void finishValue() {
        int nextCharacter = this.source.peekCharacter();
        if (!Character.INSTANCE.isValueBoundary(nextCharacter)) {
            throw (Throwable)this.unexpectedCharacter(nextCharacter, "end of value", this.source.getSourceIndex());
        }
    }

    @Override
    @Nullable
    public JSONToken getNextToken() {
        JSONToken peekedToken;
        this.assertNotClosed();
        if (this.peekedTokenIndex >= 0) {
            return this.peekedToken;
        }
        this.peekedToken = peekedToken = this.peekToken();
        this.peekedTokenIndex = this.source.getSourceIndex();
        return peekedToken;
    }

    private final JSONToken peekToken() {
        TextInput source = this.source;
        while (true) {
            source.skipWhitespaceCharacters();
            int character = source.peekCharacter();
            block0 : switch (StandardReader$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    switch (character) {
                        case 44: {
                            this.state = State.afterListElementSeparator;
                            source.readCharacter();
                            break block0;
                        }
                        case 93: {
                            this.restoreState();
                            return JSONToken.listEnd;
                        }
                    }
                    throw (Throwable)StandardReader.unexpectedCharacter$default(this, character, "',' or ']'", 0, 4, null);
                }
                case 2: {
                    this.state = State.afterListElement;
                    return this.peekValueToken("a value");
                }
                case 3: {
                    switch (character) {
                        case 93: {
                            this.restoreState();
                            return JSONToken.listEnd;
                        }
                    }
                    this.state = State.afterListElement;
                    return this.peekValueToken("a value or ']'");
                }
                case 4: {
                    switch (character) {
                        case 44: {
                            this.state = State.afterMapElementSeparator;
                            source.readCharacter();
                            break block0;
                        }
                        case 125: {
                            this.restoreState();
                            return JSONToken.mapEnd;
                        }
                    }
                    throw (Throwable)StandardReader.unexpectedCharacter$default(this, character, "',' or '}'", 0, 4, null);
                }
                case 5: {
                    switch (character) {
                        case 34: {
                            this.state = State.afterMapKey;
                            return JSONToken.mapKey;
                        }
                    }
                    throw (Throwable)StandardReader.unexpectedCharacter$default(this, character, "'\"'", 0, 4, null);
                }
                case 6: {
                    switch (character) {
                        case 58: {
                            this.state = State.afterMapKeySeparator;
                            source.readCharacter();
                            break block0;
                        }
                    }
                    throw (Throwable)StandardReader.unexpectedCharacter$default(this, character, "':'", 0, 4, null);
                }
                case 7: {
                    this.state = State.afterMapElement;
                    return this.peekValueToken("a value");
                }
                case 8: {
                    switch (character) {
                        case 34: {
                            this.state = State.afterMapKey;
                            return JSONToken.mapKey;
                        }
                        case 125: {
                            this.restoreState();
                            return JSONToken.mapEnd;
                        }
                    }
                    throw (Throwable)StandardReader.unexpectedCharacter$default(this, character, "'\"' or '}'", 0, 4, null);
                }
                case 9: {
                    switch (character) {
                        case -1: {
                            return null;
                        }
                    }
                    throw (Throwable)StandardReader.unexpectedCharacter$default(this, character, "end of input", 0, 4, null);
                }
                case 10: {
                    this.state = State.end;
                    return this.peekValueToken("a value");
                }
            }
        }
    }

    private final JSONToken peekValueToken(String expected) {
        JSONToken jSONToken;
        int character = this.source.peekCharacter();
        switch (character) {
            case 34: {
                jSONToken = JSONToken.stringValue;
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jSONToken = JSONToken.numberValue;
                break;
            }
            case 102: 
            case 116: {
                jSONToken = JSONToken.booleanValue;
                break;
            }
            case 110: {
                jSONToken = JSONToken.nullValue;
                break;
            }
            case 123: {
                this.saveState();
                this.state = State.afterMapStart;
                jSONToken = JSONToken.mapStart;
                break;
            }
            case 91: {
                this.saveState();
                this.state = State.afterListStart;
                jSONToken = JSONToken.listStart;
                break;
            }
            default: {
                throw (Throwable)StandardReader.unexpectedCharacter$default(this, character, expected, 0, 4, null);
            }
        }
        return jSONToken;
    }

    @Override
    public boolean readBoolean() {
        this.readToken(JSONToken.booleanValue);
        TextInput source = this.source;
        if (source.peekCharacter() == 116) {
            source.readCharacter(116);
            source.readCharacter(114);
            source.readCharacter(117);
            source.readCharacter(101);
            this.finishValue();
            return true;
        }
        source.readCharacter(102);
        source.readCharacter(97);
        source.readCharacter(108);
        source.readCharacter(115);
        source.readCharacter(101);
        this.finishValue();
        return false;
    }

    @Override
    public double readDouble() {
        this.readNumberIntoBuffer();
        String string = this.buffer.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.toString()");
        String string2 = string;
        return Double.parseDouble(string2);
    }

    @Override
    public float readFloat() {
        this.readNumberIntoBuffer();
        String string = this.buffer.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.toString()");
        String string2 = string;
        return Float.parseFloat(string2);
    }

    @Override
    public void readListEnd() {
        this.readToken(JSONToken.listEnd);
        this.source.readCharacter(93);
    }

    @Override
    public void readListStart() {
        this.readToken(JSONToken.listStart);
        this.source.readCharacter(91);
    }

    @Override
    public long readLong() {
        this.readToken(JSONToken.numberValue);
        return ((Number)this.source.locked((Function0)new Function0<Long>(this){
            final /* synthetic */ StandardReader this$0;

            public final long invoke() {
                return StandardReader.access$readLongLocked(this.this$0);
            }
            {
                this.this$0 = standardReader;
                super(0);
            }
        })).longValue();
    }

    /*
     * WARNING - void declaration
     */
    private final long readLongLocked() {
        TextInput this_$iv;
        long negativeLimit;
        boolean isNegative;
        int startIndex = this.source.getIndex();
        TextInput source = this.source;
        int character = source.readCharacter();
        if (character == 45) {
            void this_$iv2;
            isNegative = true;
            TextInput textInput = source;
            Character character2 = Character.INSTANCE;
            int character$iv = this_$iv2.readCharacter();
            int p1 = character$iv;
            if (!character2.isDigit(p1)) {
                int n = character$iv;
                JSONException.Companion companion = JSONException.Companion;
                String string = "a digit";
                throw (Throwable)companion.unexpectedCharacter$fluid_json(n, string, TextInput.access$getBufferStartIndex$p((TextInput)this_$iv2) - 1);
            }
            character = character$iv;
            negativeLimit = Long.MIN_VALUE;
        } else {
            isNegative = false;
            negativeLimit = -9223372036854775807L;
        }
        long minimumBeforeMultiplication = negativeLimit / (long)10;
        long value = 0L;
        if (character == 48) {
            this_$iv = source;
            int character$iv = this_$iv.readCharacter();
            int it = character$iv;
            if (!(!Character.INSTANCE.isDigit(it))) {
                int n = character$iv;
                JSONException.Companion companion = JSONException.Companion;
                String string = Character.INSTANCE.toString(46, 101, 69) + " or end of number after a leading '0'";
                throw (Throwable)companion.unexpectedCharacter$fluid_json(n, string, TextInput.access$getBufferStartIndex$p(this_$iv) - 1);
            }
            character = character$iv;
        } else {
            do {
                int digit = character - 48;
                if (value < minimumBeforeMultiplication) {
                    value = negativeLimit;
                    while (Character.INSTANCE.isDigit(character = source.readCharacter())) {
                    }
                    break;
                }
                if ((value *= (long)10) < negativeLimit + (long)digit) {
                    value = negativeLimit;
                    while (Character.INSTANCE.isDigit(character = source.readCharacter())) {
                    }
                    break;
                }
                value -= (long)digit;
            } while (Character.INSTANCE.isDigit(character = source.readCharacter()));
            if (!isNegative) {
                value *= (long)-1;
            }
        }
        if (character == 46) {
            TextInput digit = source;
            Character character3 = Character.INSTANCE;
            int character$iv = this_$iv.readCharacter();
            int p1 = character$iv;
            if (!character3.isDigit(p1)) {
                int n = character$iv;
                JSONException.Companion companion = JSONException.Companion;
                String string = "a digit in decimal value of number";
                throw (Throwable)companion.unexpectedCharacter$fluid_json(n, string, TextInput.access$getBufferStartIndex$p(this_$iv) - 1);
            }
            while (Character.INSTANCE.isDigit(character = source.readCharacter())) {
            }
        }
        if (character == 101 || character == 69) {
            source.seekTo(startIndex);
            this.unreadToken(JSONToken.numberValue);
            return (long)this.readDouble();
        }
        source.seekBackOneCharacter();
        this.finishValue();
        return value;
    }

    @Override
    public void readMapEnd() {
        this.readToken(JSONToken.mapEnd);
        this.source.readCharacter(125);
    }

    @Override
    public void readMapStart() {
        this.readToken(JSONToken.mapStart);
        this.source.readCharacter(123);
    }

    @Override
    @Nullable
    public Void readNull() {
        this.readToken(JSONToken.nullValue);
        TextInput source = this.source;
        source.readCharacter(110);
        source.readCharacter(117);
        source.readCharacter(108);
        source.readCharacter(108);
        this.finishValue();
        return null;
    }

    @Override
    @NotNull
    public Number readNumber() {
        Long value;
        boolean shouldParseAsFloatingPoint = this.readNumberIntoBuffer();
        String string = this.buffer.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.toString()");
        String stringValue = string;
        if (!shouldParseAsFloatingPoint && (value = StringsKt.toLongOrNull((String)stringValue)) != null) {
            long l = value;
            return (long)Integer.MIN_VALUE <= l && (long)Integer.MAX_VALUE >= l ? (Number)((int)value.longValue()) : (Number)value;
        }
        String string2 = stringValue;
        return Double.parseDouble(string2);
    }

    private final boolean readNumberIntoBuffer() {
        int p1;
        int character$iv;
        TextInput this_$iv;
        this.readToken(JSONToken.numberValue);
        StringBuilder buffer = this.buffer;
        buffer.setLength(0);
        boolean shouldParseAsFloatingPoint = false;
        TextInput source = this.source;
        int character = source.readCharacter();
        if (character == 45) {
            buffer.append('-');
            character = source.readCharacter();
        }
        switch (character) {
            case 48: {
                int character$iv2;
                buffer.append('0');
                this_$iv = source;
                int it = character$iv2 = this_$iv.readCharacter();
                if (!(!Character.INSTANCE.isDigit(it))) {
                    int n = character$iv2;
                    JSONException.Companion companion = JSONException.Companion;
                    String string = Character.INSTANCE.toString(46, 101, 69) + " or end of number after a leading '0'";
                    throw (Throwable)companion.unexpectedCharacter$fluid_json(n, string, TextInput.access$getBufferStartIndex$p(this_$iv) - 1);
                }
                character = character$iv2;
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                do {
                    buffer.append((char)character);
                } while (Character.INSTANCE.isDigit(character = source.readCharacter()));
                break;
            }
            default: {
                throw (Throwable)this.unexpectedCharacter(character, "a digit in integer value of number", source.getSourceIndex() - 1);
            }
        }
        if (character == 46) {
            shouldParseAsFloatingPoint = true;
            buffer.append('.');
            this_$iv = source;
            Character character2 = Character.INSTANCE;
            p1 = character$iv = this_$iv.readCharacter();
            if (!character2.isDigit(p1)) {
                int n = character$iv;
                JSONException.Companion companion = JSONException.Companion;
                String string = "a digit in decimal value of number";
                throw (Throwable)companion.unexpectedCharacter$fluid_json(n, string, TextInput.access$getBufferStartIndex$p(this_$iv) - 1);
            }
            character = character$iv;
            do {
                buffer.append((char)character);
            } while (Character.INSTANCE.isDigit(character = source.readCharacter()));
        }
        if (character == 101 || character == 69) {
            Character character3;
            shouldParseAsFloatingPoint = true;
            buffer.append((char)character);
            character = source.peekCharacter();
            if (character == 43 || character == 45) {
                buffer.append((char)character);
                source.readCharacter();
            }
            if (!(character3 = Character.INSTANCE).isDigit(p1 = (character$iv = (this_$iv = source).readCharacter()))) {
                int n = character$iv;
                JSONException.Companion companion = JSONException.Companion;
                String string = "a digit in exponent value of number";
                throw (Throwable)companion.unexpectedCharacter$fluid_json(n, string, TextInput.access$getBufferStartIndex$p(this_$iv) - 1);
            }
            character = character$iv;
            do {
                buffer.append((char)character);
            } while (Character.INSTANCE.isDigit(character = source.readCharacter()));
        }
        source.seekBackOneCharacter();
        this.finishValue();
        return shouldParseAsFloatingPoint;
    }

    @Override
    @NotNull
    public String readString() {
        this.readToken(JSONToken.stringValue, JSONToken.mapKey);
        return (String)this.source.locked((Function0)new Function0<String>(this){
            final /* synthetic */ StandardReader this$0;

            @NotNull
            public final String invoke() {
                return StandardReader.access$readStringLocked(this.this$0);
            }
            {
                this.this$0 = standardReader;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final String readStringLocked() {
        int character;
        TextInput source = this.source;
        source.readCharacter(34);
        StringBuilder buffer = this.buffer;
        buffer.setLength(0);
        int startIndex = source.getIndex();
        do {
            character = source.readCharacter();
            switch (character) {
                case 92: {
                    int endIndex = source.getIndex() - 1;
                    if (endIndex > startIndex) {
                        buffer.append(source.getBuffer(), startIndex, endIndex - startIndex);
                    }
                    character = source.readCharacter();
                    switch (character) {
                        case 47: 
                        case 92: {
                            buffer.append((char)character);
                            break;
                        }
                        case 34: {
                            buffer.append((char)character);
                            character = 0;
                            break;
                        }
                        case 98: {
                            buffer.append('\b');
                            break;
                        }
                        case 102: {
                            buffer.append('\f');
                            break;
                        }
                        case 110: {
                            buffer.append('\n');
                            break;
                        }
                        case 114: {
                            buffer.append('\r');
                            break;
                        }
                        case 116: {
                            buffer.append('\t');
                            break;
                        }
                        case 117: {
                            void this_$iv;
                            void this_$iv2;
                            void this_$iv3;
                            void this_$iv4;
                            int character$iv22;
                            TextInput textInput = source;
                            Object object = Character.INSTANCE;
                            int p1 = character$iv22 = this_$iv4.readCharacter();
                            if (!((Character)object).isHexDigit(p1)) {
                                int n = character$iv22;
                                JSONException.Companion companion = JSONException.Companion;
                                String string = "0-9, a-f or A-F";
                                throw (Throwable)companion.unexpectedCharacter$fluid_json(n, string, TextInput.access$getBufferStartIndex$p((TextInput)this_$iv4) - 1);
                            }
                            int digit1 = character$iv22;
                            object = source;
                            Object character$iv22 = Character.INSTANCE;
                            int character$iv32 = this_$iv3.readCharacter();
                            int p12 = character$iv32;
                            if (!((Character)character$iv22).isHexDigit(p12)) {
                                int n = character$iv32;
                                JSONException.Companion companion = JSONException.Companion;
                                String string = "0-9, a-f or A-F";
                                throw (Throwable)companion.unexpectedCharacter$fluid_json(n, string, TextInput.access$getBufferStartIndex$p((TextInput)this_$iv3) - 1);
                            }
                            int digit2 = character$iv32;
                            character$iv22 = source;
                            Object character$iv32 = Character.INSTANCE;
                            int character$iv = this_$iv2.readCharacter();
                            int p13 = character$iv;
                            if (!((Character)character$iv32).isHexDigit(p13)) {
                                int n = character$iv;
                                JSONException.Companion companion = JSONException.Companion;
                                String string = "0-9, a-f or A-F";
                                throw (Throwable)companion.unexpectedCharacter$fluid_json(n, string, TextInput.access$getBufferStartIndex$p((TextInput)this_$iv2) - 1);
                            }
                            int digit3 = character$iv;
                            character$iv32 = source;
                            Character character2 = Character.INSTANCE;
                            int character$iv4 = this_$iv.readCharacter();
                            int p14 = character$iv4;
                            if (!character2.isHexDigit(p14)) {
                                int n = character$iv4;
                                JSONException.Companion companion = JSONException.Companion;
                                String string = "0-9, a-f or A-F";
                                throw (Throwable)companion.unexpectedCharacter$fluid_json(n, string, TextInput.access$getBufferStartIndex$p((TextInput)this_$iv) - 1);
                            }
                            int digit4 = character$iv4;
                            int decodedCharacter = Character.INSTANCE.parseHexDigit(digit1) << 12 | Character.INSTANCE.parseHexDigit(digit2) << 8 | Character.INSTANCE.parseHexDigit(digit3) << 4 | Character.INSTANCE.parseHexDigit(digit4);
                            buffer.append((char)decodedCharacter);
                            break;
                        }
                        default: {
                            throw (Throwable)StandardReader.unexpectedCharacter$default(this, character, "an escape sequence starting with '\\', '/', '\"', 'b', 'f', 'n', 'r', 't' or 'u'", 0, 4, null);
                        }
                    }
                    startIndex = source.getIndex();
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    throw (Throwable)StandardReader.unexpectedCharacter$default(this, character, "an escape sequence", 0, 4, null);
                }
                case 34: {
                    break;
                }
                case -1: {
                    throw (Throwable)new JSONException("unterminated string value", null, 2, null);
                }
            }
        } while (character != 34);
        int endIndex = source.getIndex() - 1;
        if (endIndex > startIndex) {
            buffer.append(source.getBuffer(), startIndex, endIndex - startIndex);
        }
        String string = buffer.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.toString()");
        return string;
    }

    private final void readToken(JSONToken required) {
        JSONToken token = this.getNextToken();
        if (token != required) {
            throw (Throwable)JSONException.Companion.unexpectedToken$fluid_json(token, "" + '\'' + (Object)((Object)required) + '\'', this.peekedTokenIndex);
        }
        this.peekedToken = null;
        this.peekedTokenIndex = -1;
    }

    private final void readToken(JSONToken required, JSONToken alternative) {
        JSONToken token = this.getNextToken();
        if (token != required && token != alternative) {
            throw (Throwable)JSONException.Companion.unexpectedToken$fluid_json(token, "" + '\'' + (Object)((Object)required) + "' or '" + (Object)((Object)alternative) + '\'', this.peekedTokenIndex);
        }
        this.peekedToken = null;
        this.peekedTokenIndex = -1;
    }

    private final void restoreState() {
        this.state = this.stateStack.remove(this.stateStack.size() - 1);
    }

    private final void saveState() {
        this.stateStack.add(this.state);
    }

    private final JSONException unexpectedCharacter(int character, String expected, int characterIndex) {
        return JSONException.Companion.unexpectedCharacter$fluid_json(character, expected, characterIndex);
    }

    static /* synthetic */ JSONException unexpectedCharacter$default(StandardReader standardReader, int n, String string, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = standardReader.source.getSourceIndex();
        }
        return standardReader.unexpectedCharacter(n, string, n2);
    }

    private final void unreadToken(JSONToken token) {
        this.peekedToken = token;
        this.peekedTokenIndex = this.source.getSourceIndex();
    }

    public StandardReader(@NotNull TextInput source) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.source = source;
        this.buffer = new StringBuilder();
        this.peekedTokenIndex = -1;
        this.state = State.initial;
        StandardReader standardReader = this;
        standardReader.stateStack = list = (List)new ArrayList();
    }

    @Override
    public byte readByte() {
        return JSONReader.DefaultImpls.readByte(this);
    }

    @Override
    public int readInt() {
        return JSONReader.DefaultImpls.readInt(this);
    }

    @Override
    @NotNull
    public String readMapKey() {
        return JSONReader.DefaultImpls.readMapKey(this);
    }

    @Override
    public short readShort() {
        return JSONReader.DefaultImpls.readShort(this);
    }

    @Override
    @NotNull
    public Object readValue() {
        return JSONReader.DefaultImpls.readValue(this);
    }

    @Override
    public void skipValue() {
        JSONReader.DefaultImpls.skipValue(this);
    }

    public static final /* synthetic */ long access$readLongLocked(StandardReader $this) {
        return $this.readLongLocked();
    }

    @NotNull
    public static final /* synthetic */ String access$readStringLocked(StandardReader $this) {
        return $this.readStringLocked();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\r\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/github/fluidsonic/fluid/json/StandardReader$State;", "", "(Ljava/lang/String;I)V", "afterListElementSeparator", "afterListElement", "afterListStart", "afterMapElement", "afterMapElementSeparator", "afterMapKey", "afterMapKeySeparator", "afterMapStart", "closed", "end", "initial", "fluid-json"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State afterListElementSeparator;
        public static final /* enum */ State afterListElement;
        public static final /* enum */ State afterListStart;
        public static final /* enum */ State afterMapElement;
        public static final /* enum */ State afterMapElementSeparator;
        public static final /* enum */ State afterMapKey;
        public static final /* enum */ State afterMapKeySeparator;
        public static final /* enum */ State afterMapStart;
        public static final /* enum */ State closed;
        public static final /* enum */ State end;
        public static final /* enum */ State initial;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[11];
            State[] stateArray2 = stateArray;
            stateArray[0] = afterListElementSeparator = new State();
            stateArray[1] = afterListElement = new State();
            stateArray[2] = afterListStart = new State();
            stateArray[3] = afterMapElement = new State();
            stateArray[4] = afterMapElementSeparator = new State();
            stateArray[5] = afterMapKey = new State();
            stateArray[6] = afterMapKeySeparator = new State();
            stateArray[7] = afterMapStart = new State();
            stateArray[8] = closed = new State();
            stateArray[9] = end = new State();
            stateArray[10] = initial = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

