/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluidsonic.fluid.json;

import com.github.fluidsonic.fluid.json.AbstractJSONCodec;
import com.github.fluidsonic.fluid.json.JSONCodableType;
import com.github.fluidsonic.fluid.json.JSONCoderContext;
import com.github.fluidsonic.fluid.json.JSONDecoder;
import com.github.fluidsonic.fluid.json.JSONEncoder;
import com.github.fluidsonic.fluid.json.JSONException;
import java.time.DateTimeException;
import java.time.LocalTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00022\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0016J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/github/fluidsonic/fluid/json/LocalTimeJSONCodec;", "Lcom/github/fluidsonic/fluid/json/AbstractJSONCodec;", "Ljava/time/LocalTime;", "Lcom/github/fluidsonic/fluid/json/JSONCoderContext;", "()V", "decode", "valueType", "Lcom/github/fluidsonic/fluid/json/JSONCodableType;", "decoder", "Lcom/github/fluidsonic/fluid/json/JSONDecoder;", "encode", "", "value", "encoder", "Lcom/github/fluidsonic/fluid/json/JSONEncoder;", "fluid-json"})
public final class LocalTimeJSONCodec
extends AbstractJSONCodec<LocalTime, JSONCoderContext> {
    public static final LocalTimeJSONCodec INSTANCE;

    @Override
    @NotNull
    public LocalTime decode(@NotNull JSONCodableType<? super LocalTime> valueType, @NotNull JSONDecoder<? extends JSONCoderContext> decoder) {
        LocalTime localTime;
        String string;
        Intrinsics.checkParameterIsNotNull(valueType, (String)"valueType");
        Intrinsics.checkParameterIsNotNull(decoder, (String)"decoder");
        String raw = string = decoder.readString();
        try {
            LocalTime localTime2 = LocalTime.parse(raw);
            if (localTime2 == null) {
                Intrinsics.throwNpe();
            }
            localTime = localTime2;
        }
        catch (DateTimeException e) {
            throw (Throwable)new JSONException("Cannot parse LocalTime value: " + raw, null, 2, null);
        }
        return localTime;
    }

    @Override
    public void encode(@NotNull LocalTime value, @NotNull JSONEncoder<? extends JSONCoderContext> encoder) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull(encoder, (String)"encoder");
        String string = value.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.toString()");
        encoder.writeString(string);
    }

    private LocalTimeJSONCodec() {
        super(null, 1, null);
    }

    static {
        LocalTimeJSONCodec localTimeJSONCodec;
        INSTANCE = localTimeJSONCodec = new LocalTimeJSONCodec();
    }
}

