/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluidsonic.fluid.json;

import com.github.fluidsonic.fluid.json.AbstractJSONCodec;
import com.github.fluidsonic.fluid.json.JSONCodableType;
import com.github.fluidsonic.fluid.json.JSONCoderContext;
import com.github.fluidsonic.fluid.json.JSONDecoder;
import com.github.fluidsonic.fluid.json.JSONEncoder;
import com.github.fluidsonic.fluid.json.JSONException;
import java.time.DateTimeException;
import java.time.MonthDay;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00022\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0016J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/github/fluidsonic/fluid/json/MonthDayJSONCodec;", "Lcom/github/fluidsonic/fluid/json/AbstractJSONCodec;", "Ljava/time/MonthDay;", "Lcom/github/fluidsonic/fluid/json/JSONCoderContext;", "()V", "decode", "valueType", "Lcom/github/fluidsonic/fluid/json/JSONCodableType;", "decoder", "Lcom/github/fluidsonic/fluid/json/JSONDecoder;", "encode", "", "value", "encoder", "Lcom/github/fluidsonic/fluid/json/JSONEncoder;", "fluid-json"})
public final class MonthDayJSONCodec
extends AbstractJSONCodec<MonthDay, JSONCoderContext> {
    public static final MonthDayJSONCodec INSTANCE;

    @Override
    @NotNull
    public MonthDay decode(@NotNull JSONCodableType<? super MonthDay> valueType, @NotNull JSONDecoder<? extends JSONCoderContext> decoder) {
        MonthDay monthDay;
        String string;
        Intrinsics.checkParameterIsNotNull(valueType, (String)"valueType");
        Intrinsics.checkParameterIsNotNull(decoder, (String)"decoder");
        String raw = string = decoder.readString();
        try {
            MonthDay monthDay2 = MonthDay.parse(raw);
            if (monthDay2 == null) {
                Intrinsics.throwNpe();
            }
            monthDay = monthDay2;
        }
        catch (DateTimeException e) {
            throw (Throwable)new JSONException("Cannot parse MonthDay value: " + raw, null, 2, null);
        }
        return monthDay;
    }

    @Override
    public void encode(@NotNull MonthDay value, @NotNull JSONEncoder<? extends JSONCoderContext> encoder) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull(encoder, (String)"encoder");
        String string = value.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.toString()");
        encoder.writeString(string);
    }

    private MonthDayJSONCodec() {
        super(null, 1, null);
    }

    static {
        MonthDayJSONCodec monthDayJSONCodec;
        INSTANCE = monthDayJSONCodec = new MonthDayJSONCodec();
    }
}

