/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluidsonic.fluid.json;

import com.github.fluidsonic.fluid.json.JSONException;
import com.github.fluidsonic.fluid.json.JSONWriter;
import com.github.fluidsonic.fluid.json.StandardWriter$WhenMappings;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 ,2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002,-B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0012H\u0096\u0001J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0012H\u0016J\b\u0010\"\u001a\u00020\u0012H\u0016J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016J\b\u0010&\u001a\u00020\u0012H\u0016J\b\u0010'\u001a\u00020\u0012H\u0016J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020+H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/github/fluidsonic/fluid/json/StandardWriter;", "Lcom/github/fluidsonic/fluid/json/JSONWriter;", "Ljava/io/Closeable;", "Ljava/io/Flushable;", "destination", "Ljava/io/Writer;", "(Ljava/io/Writer;)V", "<set-?>", "", "isErrored", "()Z", "setErrored", "(Z)V", "state", "Lcom/github/fluidsonic/fluid/json/StandardWriter$State;", "stateStack", "", "close", "", "flush", "markAsErrored", "startValue", "isString", "writeBoolean", "value", "writeByte", "", "writeDouble", "", "writeFloat", "", "writeInt", "", "writeListEnd", "writeListStart", "writeLong", "", "writeMapEnd", "writeMapStart", "writeNull", "writeShort", "", "writeString", "", "Companion", "State", "fluid-json"})
public final class StandardWriter
implements JSONWriter,
Closeable,
Flushable {
    private State state;
    private final List<State> stateStack;
    private boolean isErrored;
    private final Writer destination;
    @NotNull
    private static final char[] hexCharacters;
    @Deprecated
    public static final Companion Companion;

    @Override
    public boolean isErrored() {
        return this.isErrored;
    }

    private void setErrored(boolean bl) {
        this.isErrored = bl;
    }

    @Override
    public void close() {
        State stateBeforeClosing = this.state;
        if (stateBeforeClosing == State.closed) {
            return;
        }
        this.state = State.closed;
        this.destination.close();
        if (!this.isErrored() && stateBeforeClosing != State.end) {
            throw (Throwable)new JSONException("Must not close writer before all values were fully written.", null, 2, null);
        }
    }

    @Override
    public void markAsErrored() {
        this.setErrored(true);
    }

    private final void startValue(boolean isString) {
        switch (StandardWriter$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                this.destination.write(44);
                break;
            }
            case 2: {
                this.state = State.afterListElement;
                break;
            }
            case 3: {
                if (isString) {
                    this.destination.write(44);
                    this.state = State.afterMapKey;
                    break;
                }
                throw (Throwable)new JSONException("Expected a string as map key", null, 2, null);
            }
            case 4: {
                this.destination.write(58);
                this.state = State.afterMapElement;
                break;
            }
            case 5: {
                if (isString) {
                    this.state = State.afterMapKey;
                    break;
                }
                throw (Throwable)new JSONException("Expected a string as map key", null, 2, null);
            }
            case 6: {
                throw (Throwable)new IOException("Cannot operate on a closed writer");
            }
            case 7: {
                throw (Throwable)new JSONException("Cannot write more than one value a the JSON root", null, 2, null);
            }
            case 8: {
                this.state = State.end;
            }
        }
    }

    @Override
    public void writeBoolean(boolean value) {
        StandardWriter $receiver$iv = this;
        if ($receiver$iv.isErrored()) {
            throw (Throwable)new IOException("Cannot operate on an errored writer");
        }
        try {
            StandardWriter $receiver = $receiver$iv;
            $receiver.startValue(false);
            $receiver.destination.write(value ? "true" : "false");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            $receiver$iv.markAsErrored();
            throw e$iv;
        }
    }

    @Override
    public void writeByte(byte value) {
        StandardWriter $receiver$iv = this;
        if ($receiver$iv.isErrored()) {
            throw (Throwable)new IOException("Cannot operate on an errored writer");
        }
        try {
            StandardWriter $receiver = $receiver$iv;
            $receiver.startValue(false);
            $receiver.destination.write(String.valueOf(value));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            $receiver$iv.markAsErrored();
            throw e$iv;
        }
    }

    @Override
    public void writeDouble(double value) {
        StandardWriter $receiver$iv = this;
        if ($receiver$iv.isErrored()) {
            throw (Throwable)new IOException("Cannot operate on an errored writer");
        }
        try {
            double d;
            StandardWriter $receiver = $receiver$iv;
            $receiver.startValue(false);
            double d2 = d = value;
            if (!(!Double.isInfinite(d2) && !Double.isNaN(d2 = d))) {
                throw (Throwable)new JSONException("Cannot write double value '" + value + '\'', null, 2, null);
            }
            $receiver.destination.write(String.valueOf(value));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            $receiver$iv.markAsErrored();
            throw e$iv;
        }
    }

    @Override
    public void writeFloat(float value) {
        StandardWriter $receiver$iv = this;
        if ($receiver$iv.isErrored()) {
            throw (Throwable)new IOException("Cannot operate on an errored writer");
        }
        try {
            float f;
            StandardWriter $receiver = $receiver$iv;
            $receiver.startValue(false);
            float f2 = f = value;
            if (!(!Float.isInfinite(f2) && !Float.isNaN(f2 = f))) {
                throw (Throwable)new JSONException("Cannot write float value '" + value + '\'', null, 2, null);
            }
            $receiver.destination.write(String.valueOf(value));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            $receiver$iv.markAsErrored();
            throw e$iv;
        }
    }

    @Override
    public void writeInt(int value) {
        StandardWriter $receiver$iv = this;
        if ($receiver$iv.isErrored()) {
            throw (Throwable)new IOException("Cannot operate on an errored writer");
        }
        try {
            StandardWriter $receiver = $receiver$iv;
            $receiver.startValue(false);
            $receiver.destination.write(String.valueOf(value));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            $receiver$iv.markAsErrored();
            throw e$iv;
        }
    }

    @Override
    public void writeLong(long value) {
        StandardWriter $receiver$iv = this;
        if ($receiver$iv.isErrored()) {
            throw (Throwable)new IOException("Cannot operate on an errored writer");
        }
        try {
            StandardWriter $receiver = $receiver$iv;
            $receiver.startValue(false);
            $receiver.destination.write(String.valueOf(value));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            $receiver$iv.markAsErrored();
            throw e$iv;
        }
    }

    @Override
    public void writeListEnd() {
        StandardWriter $receiver$iv = this;
        if ($receiver$iv.isErrored()) {
            throw (Throwable)new IOException("Cannot operate on an errored writer");
        }
        try {
            StandardWriter $receiver = $receiver$iv;
            switch (StandardWriter$WhenMappings.$EnumSwitchMapping$1[$receiver.state.ordinal()]) {
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    throw (Throwable)new IOException("Cannot operate on a closed writer");
                }
                default: {
                    throw (Throwable)new JSONException("Cannot write end of list when not in a list", null, 2, null);
                }
            }
            $receiver.destination.write(93);
            $receiver.state = $receiver.stateStack.remove($receiver.stateStack.size() - 1);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            $receiver$iv.markAsErrored();
            throw e$iv;
        }
    }

    @Override
    public void writeListStart() {
        StandardWriter $receiver$iv = this;
        if ($receiver$iv.isErrored()) {
            throw (Throwable)new IOException("Cannot operate on an errored writer");
        }
        try {
            StandardWriter $receiver = $receiver$iv;
            $receiver.startValue(false);
            $receiver.destination.write(91);
            Collection collection = $receiver.stateStack;
            State state = $receiver.state;
            collection.add(state);
            $receiver.state = State.afterListStart;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            $receiver$iv.markAsErrored();
            throw e$iv;
        }
    }

    @Override
    public void writeMapEnd() {
        StandardWriter $receiver$iv = this;
        if ($receiver$iv.isErrored()) {
            throw (Throwable)new IOException("Cannot operate on an errored writer");
        }
        try {
            StandardWriter $receiver = $receiver$iv;
            switch (StandardWriter$WhenMappings.$EnumSwitchMapping$2[$receiver.state.ordinal()]) {
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    throw (Throwable)new JSONException("Cannot write end of map right after a key, value expected instead", null, 2, null);
                }
                case 4: {
                    throw (Throwable)new IOException("Cannot operate on a closed writer");
                }
                default: {
                    throw (Throwable)new JSONException("Cannot write end of map when not in a map", null, 2, null);
                }
            }
            $receiver.destination.write(125);
            $receiver.state = $receiver.stateStack.remove($receiver.stateStack.size() - 1);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            $receiver$iv.markAsErrored();
            throw e$iv;
        }
    }

    @Override
    public void writeMapStart() {
        StandardWriter $receiver$iv = this;
        if ($receiver$iv.isErrored()) {
            throw (Throwable)new IOException("Cannot operate on an errored writer");
        }
        try {
            StandardWriter $receiver = $receiver$iv;
            $receiver.startValue(false);
            $receiver.destination.write(123);
            Collection collection = $receiver.stateStack;
            State state = $receiver.state;
            collection.add(state);
            $receiver.state = State.afterMapStart;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            $receiver$iv.markAsErrored();
            throw e$iv;
        }
    }

    @Override
    public void writeNull() {
        StandardWriter $receiver$iv = this;
        if ($receiver$iv.isErrored()) {
            throw (Throwable)new IOException("Cannot operate on an errored writer");
        }
        try {
            StandardWriter $receiver = $receiver$iv;
            $receiver.startValue(false);
            $receiver.destination.write("null");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            $receiver$iv.markAsErrored();
            throw e$iv;
        }
    }

    @Override
    public void writeShort(short value) {
        StandardWriter $receiver$iv = this;
        if ($receiver$iv.isErrored()) {
            throw (Throwable)new IOException("Cannot operate on an errored writer");
        }
        try {
            StandardWriter $receiver = $receiver$iv;
            $receiver.startValue(false);
            $receiver.destination.write(String.valueOf(value));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            $receiver$iv.markAsErrored();
            throw e$iv;
        }
    }

    @Override
    public void writeString(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        StandardWriter $receiver$iv = this;
        if ($receiver$iv.isErrored()) {
            throw (Throwable)new IOException("Cannot operate on an errored writer");
        }
        try {
            StandardWriter $receiver = $receiver$iv;
            $receiver.startValue(true);
            $receiver.destination.write(34);
            String string = value;
            int n = string.length();
            block11: for (int i = 0; i < n; ++i) {
                char character = string.charAt(i);
                switch (character) {
                    case '\"': 
                    case '\\': {
                        $receiver.destination.write(92);
                        $receiver.destination.write(character);
                        continue block11;
                    }
                    case '\b': {
                        $receiver.destination.write(92);
                        $receiver.destination.write(98);
                        continue block11;
                    }
                    case '\f': {
                        $receiver.destination.write(92);
                        $receiver.destination.write(102);
                        continue block11;
                    }
                    case '\n': {
                        $receiver.destination.write(92);
                        $receiver.destination.write(110);
                        continue block11;
                    }
                    case '\r': {
                        $receiver.destination.write(92);
                        $receiver.destination.write(114);
                        continue block11;
                    }
                    case '\t': {
                        $receiver.destination.write(92);
                        $receiver.destination.write(116);
                        continue block11;
                    }
                    case '\u0000': 
                    case '\u0001': 
                    case '\u0002': 
                    case '\u0003': 
                    case '\u0004': 
                    case '\u0005': 
                    case '\u0006': 
                    case '\u0007': 
                    case '\u000b': 
                    case '\u000e': 
                    case '\u000f': 
                    case '\u0010': 
                    case '\u0011': 
                    case '\u0012': 
                    case '\u0013': 
                    case '\u0014': 
                    case '\u0015': 
                    case '\u0016': 
                    case '\u0017': 
                    case '\u0018': 
                    case '\u0019': 
                    case '\u001a': 
                    case '\u001b': 
                    case '\u001c': 
                    case '\u001d': 
                    case '\u001e': 
                    case '\u001f': {
                        $receiver.destination.write(92);
                        $receiver.destination.write(117);
                        $receiver.destination.write(48);
                        $receiver.destination.write(48);
                        if (character >= '\u0010') {
                            $receiver.destination.write(49);
                        } else {
                            $receiver.destination.write(48);
                        }
                        $receiver.destination.write(hexCharacters[character & 0xF]);
                        continue block11;
                    }
                    default: {
                        $receiver.destination.write(character);
                    }
                }
            }
            $receiver.destination.write(34);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            $receiver$iv.markAsErrored();
            throw e$iv;
        }
    }

    public StandardWriter(@NotNull Writer destination) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        this.destination = destination;
        this.state = State.initial;
        StandardWriter standardWriter = this;
        standardWriter.stateStack = list = (List)new ArrayList();
    }

    static {
        Companion = new Companion(null);
        hexCharacters = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    @Override
    public void writeMapKey(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        JSONWriter.DefaultImpls.writeMapKey(this, value);
    }

    @Override
    public void writeNumber(@NotNull Number value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        JSONWriter.DefaultImpls.writeNumber(this, value);
    }

    @Override
    public void writeValue(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        JSONWriter.DefaultImpls.writeValue(this, value);
    }

    @Override
    public void flush() {
        this.destination.flush();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/github/fluidsonic/fluid/json/StandardWriter$State;", "", "(Ljava/lang/String;I)V", "afterListElement", "afterListStart", "afterMapElement", "afterMapKey", "afterMapStart", "closed", "end", "initial", "fluid-json"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State afterListElement;
        public static final /* enum */ State afterListStart;
        public static final /* enum */ State afterMapElement;
        public static final /* enum */ State afterMapKey;
        public static final /* enum */ State afterMapStart;
        public static final /* enum */ State closed;
        public static final /* enum */ State end;
        public static final /* enum */ State initial;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[8];
            State[] stateArray2 = stateArray;
            stateArray[0] = afterListElement = new State();
            stateArray[1] = afterListStart = new State();
            stateArray[2] = afterMapElement = new State();
            stateArray[3] = afterMapKey = new State();
            stateArray[4] = afterMapStart = new State();
            stateArray[5] = closed = new State();
            stateArray[6] = end = new State();
            stateArray[7] = initial = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/fluidsonic/fluid/json/StandardWriter$Companion;", "", "()V", "hexCharacters", "", "getHexCharacters", "()[C", "fluid-json"})
    private static final class Companion {
        @NotNull
        public final char[] getHexCharacters() {
            return hexCharacters;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

