/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluidsonic.fluid.json;

import com.github.fluidsonic.fluid.json.Character;
import java.io.Closeable;
import java.io.Reader;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u000fH\u0002J\t\u0010\u0019\u001a\u00020\u001aH\u0096\u0001J\u0006\u0010\u001b\u001a\u00020\u001aJ\u0006\u0010\u001c\u001a\u00020\rJ\u0006\u0010\u001d\u001a\u00020\rJ\u0006\u0010\u001e\u001a\u00020\u001aJ\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\rJ\u0006\u0010 \u001a\u00020\u001aJ\u0012\u0010!\u001a\u00020\r2\b\b\u0002\u0010\"\u001a\u00020\rH\u0002J\u0006\u0010#\u001a\u00020\u001aR$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/github/fluidsonic/fluid/json/TextInput;", "Ljava/io/Closeable;", "source", "Ljava/io/Reader;", "(Ljava/io/Reader;)V", "<set-?>", "", "buffer", "getBuffer", "()[C", "setBuffer", "([C)V", "bufferEndIndex", "", "bufferIsLocked", "", "bufferStartIndex", "index", "getIndex", "()I", "readCharacterCountNotInBufferAnymore", "sourceIndex", "getSourceIndex", "sourceIsAtEnd", "alignBufferStartIfNeeded", "close", "", "lockBuffer", "peekCharacter", "readCharacter", "seekBackOneCharacter", "seekTo", "skipWhitespaceCharacters", "tryPreloadCharacters", "preloadCount", "unlockBuffer", "Companion", "fluid-json"})
public final class TextInput
implements Closeable {
    private int bufferEndIndex;
    private boolean bufferIsLocked;
    private int bufferStartIndex;
    private int readCharacterCountNotInBufferAnymore;
    private boolean sourceIsAtEnd;
    @NotNull
    private char[] buffer;
    private final Reader source;
    public static final int windowSize = 2048;
    @Deprecated
    public static final Companion Companion = new Companion(null);

    private final boolean alignBufferStartIfNeeded() {
        if (this.bufferIsLocked) {
            return false;
        }
        int bufferStartIndex = this.bufferStartIndex;
        if (bufferStartIndex <= 1) {
            return true;
        }
        int unreadCharacterCount = this.bufferEndIndex - bufferStartIndex;
        if (unreadCharacterCount <= 0) {
            this.buffer[0] = this.buffer[bufferStartIndex - 1];
            this.bufferEndIndex = 1;
            this.bufferStartIndex = 1;
            this.readCharacterCountNotInBufferAnymore += bufferStartIndex - 1;
            return true;
        }
        if (bufferStartIndex >= 2049) {
            System.arraycopy(this.buffer, bufferStartIndex - 1, this.buffer, 0, unreadCharacterCount + 1);
            this.bufferEndIndex = 1 + unreadCharacterCount;
            this.bufferStartIndex = 1;
            this.readCharacterCountNotInBufferAnymore += bufferStartIndex + 1;
            return true;
        }
        return false;
    }

    @NotNull
    public final char[] getBuffer() {
        return this.buffer;
    }

    private final void setBuffer(char[] cArray) {
        this.buffer = cArray;
    }

    public final int getIndex() {
        return this.bufferStartIndex;
    }

    public final void lockBuffer() {
        boolean bl;
        boolean bl2 = bl = !this.bufferIsLocked;
        if (!bl) {
            String string = "Input is already locked.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.bufferIsLocked = true;
    }

    public final int peekCharacter() {
        return this.tryPreloadCharacters(1) > 0 ? this.buffer[this.bufferStartIndex] : -1;
    }

    public final int readCharacter() {
        int character = this.tryPreloadCharacters(1) > 0 ? this.buffer[this.bufferStartIndex] : -1;
        ++this.bufferStartIndex;
        return character;
    }

    public final void seekBackOneCharacter() {
        boolean bl;
        boolean bl2 = bl = this.bufferStartIndex > 0;
        if (!bl) {
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        --this.bufferStartIndex;
    }

    public final void seekTo(int index) {
        int n = this.bufferIsLocked;
        if (n == 0) {
            String string = "This operation is only possible with a locked buffer.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        n = index;
        int n2 = n = 0 <= n && this.bufferEndIndex - 1 >= n ? 1 : 0;
        if (n == 0) {
            String string = "index " + index + " out of bounds 0 ..< " + this.bufferEndIndex;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.bufferStartIndex = index;
    }

    public final void skipWhitespaceCharacters() {
        char character;
        int bufferStartIndex = this.bufferStartIndex;
        int bufferEndIndex = this.bufferEndIndex;
        do {
            if (bufferStartIndex >= bufferEndIndex) {
                this.bufferStartIndex = bufferStartIndex;
                if (TextInput.tryPreloadCharacters$default(this, 0, 1, null) == 0) {
                    this.bufferStartIndex = bufferEndIndex;
                    return;
                }
                bufferStartIndex = this.bufferStartIndex;
                bufferEndIndex = this.bufferEndIndex;
            }
            character = this.buffer[bufferStartIndex];
            ++bufferStartIndex;
        } while (Character.INSTANCE.isWhitespace(character));
        this.bufferStartIndex = bufferStartIndex - 1;
    }

    public final int getSourceIndex() {
        return this.readCharacterCountNotInBufferAnymore + this.bufferStartIndex;
    }

    private final int tryPreloadCharacters(int preloadCount) {
        int preloadedCount;
        int n = preloadCount;
        int n2 = n = 0 <= n && 2048 >= n ? 1 : 0;
        if (n == 0) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int bufferEndIndex = this.bufferEndIndex;
        int unreadCharacterCount = bufferEndIndex - this.bufferStartIndex;
        if (unreadCharacterCount >= preloadCount) {
            return preloadCount;
        }
        if (this.sourceIsAtEnd) {
            return 0;
        }
        char[] buffer = this.buffer;
        int bufferSize = buffer.length;
        if (bufferSize - bufferEndIndex < 2048) {
            if (this.alignBufferStartIfNeeded()) {
                bufferEndIndex = this.bufferEndIndex;
            } else {
                char[] cArray = Arrays.copyOf(buffer, bufferSize += 2048);
                Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"Arrays.copyOf(buffer, bufferSize)");
                this.buffer = buffer = cArray;
            }
        }
        if ((preloadedCount = this.source.read(buffer, bufferEndIndex, 2048)) <= 0) {
            boolean bl;
            boolean bl2 = bl = preloadedCount != 0;
            if (!bl) {
                String string = "Reader.read(\u2026) must not return 0.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.sourceIsAtEnd = true;
            return 0;
        }
        this.bufferEndIndex = bufferEndIndex += preloadedCount;
        return preloadedCount;
    }

    static /* synthetic */ int tryPreloadCharacters$default(TextInput textInput, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2048;
        }
        return textInput.tryPreloadCharacters(n);
    }

    public final void unlockBuffer() {
        boolean bl = this.bufferIsLocked;
        if (!bl) {
            String string = "Input is not locked.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.bufferIsLocked = false;
        this.alignBufferStartIfNeeded();
    }

    public TextInput(@NotNull Reader source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.source = source;
        this.buffer = new char[4097];
    }

    @Override
    public void close() {
        this.source.close();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/fluidsonic/fluid/json/TextInput$Companion;", "", "()V", "windowSize", "", "fluid-json"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

