/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.eureka.EurekaProducer;
import io.quarkus.eureka.EurekaRecorder;
import io.quarkus.eureka.client.DataCenterInfo;
import io.quarkus.eureka.client.InstanceInfo;
import io.quarkus.eureka.client.PortEnableInfo;
import io.quarkus.eureka.config.EurekaRuntimeConfiguration;
import java.util.ArrayList;

public class EurekaInfoProcessor {
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    public void applyConfiguration(EurekaRecorder eurekaRecorder, EurekaRuntimeConfiguration eurekaRuntimeConfiguration, BeanContainerBuildItem beanContainer) {
        eurekaRecorder.registerServiceInEureka(eurekaRuntimeConfiguration, beanContainer.getValue());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    public void stepConfiguration(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer, BuildProducer<BeanContainerListenerBuildItem> containerListenerProducer, BuildProducer<FeatureBuildItem> featureProducer, EurekaRecorder eurekaRecorder) {
        featureProducer.produce((BuildItem)new FeatureBuildItem("eureka"));
        AdditionalBeanBuildItem eurekaBuildItem = AdditionalBeanBuildItem.unremovableOf(EurekaProducer.class);
        additionalBeanProducer.produce((BuildItem)eurekaBuildItem);
    }

    @BuildStep
    public ReflectiveClassBuildItem registerForReflection() {
        ArrayList<String> dtos = new ArrayList<String>();
        dtos.add(InstanceInfo.class.getName());
        dtos.add(DataCenterInfo.class.getName());
        dtos.add(PortEnableInfo.class.getName());
        return new ReflectiveClassBuildItem(true, true, dtos.toArray(new String[dtos.size()]));
    }
}

