/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.eureka.EurekaProducer;
import io.quarkus.eureka.EurekaRecorder;
import io.quarkus.eureka.IsHealthEnabled;
import io.quarkus.eureka.config.EurekaBuildTimeConfiguration;
import io.quarkus.eureka.config.EurekaRuntimeConfiguration;
import io.quarkus.eureka.heartbeat.HealthCheckController;
import io.quarkus.eureka.heartbeat.StatusCheckController;
import io.quarkus.undertow.deployment.ServletBuildItem;

public class EurekaInfoProcessor {
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    public void applyConfiguration(EurekaRecorder eurekaRecorder, EurekaRuntimeConfiguration eurekaRuntimeConfiguration, BeanContainerBuildItem beanContainer) {
        eurekaRecorder.registerServiceInEureka(eurekaRuntimeConfiguration, beanContainer.getValue());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    public AdditionalBeanBuildItem stepConfiguration(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer, BuildProducer<FeatureBuildItem> featureProducer, EurekaRecorder eurekaRecorder) {
        featureProducer.produce((BuildItem)new FeatureBuildItem("eureka"));
        AdditionalBeanBuildItem eurekaBuildItem = AdditionalBeanBuildItem.unremovableOf(EurekaProducer.class);
        additionalBeanProducer.produce((BuildItem)eurekaBuildItem);
        return eurekaBuildItem;
    }

    @BuildStep(onlyIf={IsHealthEnabled.class})
    ServletBuildItem healthCheckBuildItem(EurekaBuildTimeConfiguration eurekaBuildTimeConfiguration) {
        return ServletBuildItem.builder((String)"quarkus-eureka-health", (String)HealthCheckController.class.getName()).addMapping(eurekaBuildTimeConfiguration.heartBeat().healthPath()).build();
    }

    @BuildStep(onlyIf={IsHealthEnabled.class})
    ServletBuildItem statusCheckBuildItem(EurekaBuildTimeConfiguration eurekaBuildTimeConfiguration) {
        return ServletBuildItem.builder((String)"quarkus-eureka-status", (String)StatusCheckController.class.getName()).addMapping(eurekaBuildTimeConfiguration.heartBeat().statusPath()).build();
    }
}

