/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.eureka.EurekaProducer;
import io.quarkus.eureka.client.InstanceInfo;
import io.quarkus.eureka.config.DefaultInstanceInfoContext;
import io.quarkus.eureka.config.EurekaRuntimeConfiguration;
import io.quarkus.eureka.config.ServiceLocationConfig;
import io.quarkus.eureka.operation.OperationFactory;
import io.quarkus.eureka.operation.heartbeat.HeartBeatOperation;
import io.quarkus.eureka.operation.query.MultipleInstanceQueryOperation;
import io.quarkus.eureka.operation.query.SingleInstanceQueryOperation;
import io.quarkus.eureka.operation.register.RegisterOperation;
import io.quarkus.eureka.operation.remove.RemoveInstanceOperation;
import io.quarkus.eureka.registration.EurekaRegistrationService;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import javax.ws.rs.ProcessingException;
import org.jboss.logging.Logger;

@Recorder
public class EurekaRecorder {
    private final Logger logger = Logger.getLogger(this.getClass());

    public void registerServiceInEureka(EurekaRuntimeConfiguration eurekaRuntimeConfiguration, BeanContainer beanContainer) {
        try {
            this.logger.info((Object)"registering eurekaService");
            InstanceInfo instanceInfo = InstanceInfo.of(DefaultInstanceInfoContext.withConfiguration(eurekaRuntimeConfiguration));
            ServiceLocationConfig serviceLocationConfig = new ServiceLocationConfig(eurekaRuntimeConfiguration);
            OperationFactory operationFactory = this.createOperationFactory();
            ((EurekaProducer)beanContainer.instance(EurekaProducer.class, new Annotation[0])).setOperationFactory(operationFactory);
            ((EurekaProducer)beanContainer.instance(EurekaProducer.class, new Annotation[0])).setInstanceInfo(instanceInfo);
            ((EurekaProducer)beanContainer.instance(EurekaProducer.class, new Annotation[0])).setServiceLocationConfig(serviceLocationConfig);
            new EurekaRegistrationService(serviceLocationConfig, instanceInfo, operationFactory).register();
        }
        catch (ProcessingException ex) {
            this.logger.error((Object)"error connecting with eureka registry service", ex.getCause());
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
            throw new RuntimeException(ex);
        }
    }

    private OperationFactory createOperationFactory() {
        RegisterOperation registerOperation = new RegisterOperation();
        HeartBeatOperation heartBeatOperation = new HeartBeatOperation();
        SingleInstanceQueryOperation singleQueryOperation = new SingleInstanceQueryOperation();
        MultipleInstanceQueryOperation multipleQueryOperation = new MultipleInstanceQueryOperation();
        RemoveInstanceOperation removeInstanceOperation = new RemoveInstanceOperation();
        return new OperationFactory(Arrays.asList(registerOperation, heartBeatOperation, singleQueryOperation, multipleQueryOperation, removeInstanceOperation));
    }
}

