/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka.client;

import io.quarkus.eureka.client.loadBalancer.LoadBalancer;
import io.quarkus.eureka.exception.EurekaServiceNotFoundException;
import java.util.function.Supplier;
import javax.ws.rs.client.WebTarget;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;

public class EurekaClient {
    private final LoadBalancer loadBalancer;
    private final ResteasyClient client = ((ResteasyClientBuilder)ResteasyClientBuilder.newBuilder()).connectionPoolSize(50).build();

    public EurekaClient(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public WebTarget app(String appId) {
        String target = this.loadBalancer.getHomeUrl(appId).orElseThrow(this.serviceNotFound(appId));
        return this.client.target(target);
    }

    private Supplier<EurekaServiceNotFoundException> serviceNotFound(String appId) {
        return () -> new EurekaServiceNotFoundException(appId.toUpperCase());
    }
}

