/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka.operation.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkus.eureka.client.Status;
import io.quarkus.eureka.operation.query.QueryResponse;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InstanceResult
extends QueryResponse<InstanceResult> {
    private final String instanceId;
    private final String hostName;
    private final String app;
    private final String homePageUrl;
    private final String ipAddr;
    private final Status status;

    @JsonCreator
    public InstanceResult(@JsonProperty(value="hostName") String hostName, @JsonProperty(value="instanceId") String instanceId, @JsonProperty(value="app") String app, @JsonProperty(value="homePageUrl") String homePageUrl, @JsonProperty(value="ipAddr") String ipAddr, @JsonProperty(value="status") Status status) {
        this.instanceId = instanceId;
        this.hostName = hostName;
        this.app = app;
        this.ipAddr = ipAddr;
        this.status = status;
        this.homePageUrl = homePageUrl;
    }

    private InstanceResult(Status status) {
        this(null, null, null, null, null, status);
    }

    public static InstanceResult error() {
        return new InstanceResult(Status.UNKNOWN);
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    boolean success() {
        return Status.UP.equals((Object)this.getStatus());
    }

    @Override
    InstanceResult entity() {
        return this;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHomePageUrl() {
        return this.homePageUrl;
    }

    public String getApp() {
        return this.app;
    }

    public String getIpAddr() {
        return this.ipAddr;
    }

    public String getInstanceId() {
        return this.instanceId;
    }
}

