/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka.registration;

import io.quarkus.eureka.client.Status;
import io.quarkus.eureka.exception.HealthCheckException;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;

class InstanceHealthCheckService {
    InstanceHealthCheckService() {
    }

    Status healthCheck(String healthCheckUrl) {
        try (Client client = ResteasyClientBuilder.newClient();){
            Status status;
            block12: {
                Response response = client.target(healthCheckUrl).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
                try {
                    if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.CLIENT_ERROR)) {
                        throw new HealthCheckException("Instance can't reach own application health check. Ensure this has been implemented");
                    }
                    status = this.getStatusFromResponse(response);
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ProcessingException ex) {
                        throw new HealthCheckException(String.format("Health check not reachable: %s", healthCheckUrl), ex);
                    }
                }
                response.close();
            }
            return status;
        }
    }

    private Status getStatusFromResponse(Response response) {
        if (!response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
            return Status.DOWN;
        }
        Map body = (Map)response.readEntity(Map.class);
        return body.entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase("status")).map(Map.Entry::getValue).map(String::toUpperCase).map(Status::valueOf).findFirst().orElse(Status.UNKNOWN);
    }
}

