/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka.client;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.quarkus.eureka.client.DataCenterInfo;
import io.quarkus.eureka.client.PortEnableInfo;
import io.quarkus.eureka.client.Status;
import io.quarkus.eureka.config.InstanceInfoContext;
import java.util.Map;
import java.util.function.Function;

@JsonPropertyOrder(value={"instanceId", "hostName", "app", "vipAddress", "secureVipAddress", "ipAddr", "status", "homePageUrl", "statusPageUrl", "healthCheckUrl", "secureHealthCheckUrl", "port", "securePort", "dataCenterInfo"})
public final class InstanceInfo {
    private final String instanceId;
    private final String hostName;
    private final String app;
    private final String vipAddress;
    private final String secureVipAddress;
    private final String ipAddr;
    private final Status status;
    private final String homePageUrl;
    private final String statusPageUrl;
    private final String healthCheckUrl;
    private final String secureHealthCheckUrl;
    private final PortEnableInfo port;
    private final PortEnableInfo securePort;
    private final DataCenterInfo dataCenterInfo;
    private final Map<String, String> metadata;

    private InstanceInfo(InstanceInfoContext instanceInfoCtx) {
        this.hostName = instanceInfoCtx.getHostName();
        this.app = instanceInfoCtx.getName().toUpperCase();
        this.vipAddress = instanceInfoCtx.getVipAddress();
        this.secureVipAddress = instanceInfoCtx.getVipAddress();
        this.ipAddr = instanceInfoCtx.getHostName();
        this.status = Status.STARTING;
        this.homePageUrl = this.buildUrl(instanceInfoCtx.getPort(), instanceInfoCtx.getHomePageUrl());
        this.statusPageUrl = this.buildUrl(instanceInfoCtx.getPort(), instanceInfoCtx.getStatusPageUrl());
        this.healthCheckUrl = this.buildUrl(instanceInfoCtx.getPort(), instanceInfoCtx.getHealthCheckUrl());
        this.secureHealthCheckUrl = this.buildUrl(instanceInfoCtx.getPort(), instanceInfoCtx.getHealthCheckUrl());
        this.port = PortEnableInfo.of(instanceInfoCtx.getPort(), true);
        this.securePort = PortEnableInfo.of(instanceInfoCtx.getPort(), false);
        this.dataCenterInfo = () -> DataCenterInfo.Name.MyOwn;
        this.instanceId = instanceInfoCtx.getInstanceId();
        this.metadata = instanceInfoCtx.getMetadata();
    }

    private InstanceInfo(InstanceInfo instanceInfo, Status status) {
        this.hostName = instanceInfo.getHostName();
        this.app = instanceInfo.getApp();
        this.vipAddress = instanceInfo.getVipAddress();
        this.secureVipAddress = instanceInfo.getSecureVipAddress();
        this.ipAddr = instanceInfo.getIpAddr();
        this.status = status;
        this.homePageUrl = instanceInfo.getHomePageUrl();
        this.statusPageUrl = instanceInfo.getStatusPageUrl();
        this.healthCheckUrl = instanceInfo.getHealthCheckUrl();
        this.secureHealthCheckUrl = instanceInfo.getSecureHealthCheckUrl();
        this.port = instanceInfo.getPort();
        this.securePort = instanceInfo.getSecurePort();
        this.dataCenterInfo = instanceInfo.getDataCenterInfo();
        this.instanceId = instanceInfo.getInstanceId();
        this.metadata = instanceInfo.getMetadata();
    }

    private String buildUrl(int port, String resourcePath) {
        return Function.identity().andThen(path -> path.startsWith("/") ? path.substring(1) : path).andThen(path -> String.format("http://%s:%d/%s", this.hostName, port, path)).apply(resourcePath);
    }

    public static InstanceInfo of(InstanceInfoContext instanceInfoContext) {
        return new InstanceInfo(instanceInfoContext);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getApp() {
        return this.app;
    }

    public String getVipAddress() {
        return this.vipAddress;
    }

    public String getSecureVipAddress() {
        return this.secureVipAddress;
    }

    public String getIpAddr() {
        return this.ipAddr;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getHomePageUrl() {
        return this.homePageUrl;
    }

    public String getStatusPageUrl() {
        return this.statusPageUrl;
    }

    public String getHealthCheckUrl() {
        return this.healthCheckUrl;
    }

    public String getSecureHealthCheckUrl() {
        return this.secureHealthCheckUrl;
    }

    public PortEnableInfo getPort() {
        return this.port;
    }

    public PortEnableInfo getSecurePort() {
        return this.securePort;
    }

    public DataCenterInfo getDataCenterInfo() {
        return this.dataCenterInfo;
    }

    public InstanceInfo withStatus(Status newStatus) {
        return new InstanceInfo(this, newStatus);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

