/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka.config;

import io.quarkus.eureka.config.EurekaRuntimeConfiguration;
import io.quarkus.eureka.config.InstanceInfoContext;
import io.quarkus.eureka.util.HostNameDiscovery;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultInstanceInfoContext
implements InstanceInfoContext {
    private final String name;
    private final int port;
    private final String vipAddress;
    private final String instanceId;
    private final String hostName;
    private final String homePageUrl;
    private final String statusPageUrl;
    private final String healthCheckUrl;
    private final Map<String, String> metadata;

    DefaultInstanceInfoContext(EurekaRuntimeConfiguration eurekaRuntimeConfiguration) {
        this.name = eurekaRuntimeConfiguration.name;
        this.port = eurekaRuntimeConfiguration.port;
        this.vipAddress = eurekaRuntimeConfiguration.vipAddress;
        this.homePageUrl = eurekaRuntimeConfiguration.homePageUrl;
        this.statusPageUrl = eurekaRuntimeConfiguration.statusPageUrl;
        this.healthCheckUrl = eurekaRuntimeConfiguration.healthCheckUrl;
        this.hostName = this.selectedHostname(eurekaRuntimeConfiguration);
        this.instanceId = this.buildInstanceId();
        this.metadata = this.composeMetadata(eurekaRuntimeConfiguration);
    }

    private String selectedHostname(EurekaRuntimeConfiguration eurekaRuntimeConfiguration) {
        if (eurekaRuntimeConfiguration.preferIpAddress) {
            return HostNameDiscovery.getLocalHost();
        }
        return eurekaRuntimeConfiguration.hostName;
    }

    private Map<String, String> composeMetadata(EurekaRuntimeConfiguration eurekaRuntimeConfiguration) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (eurekaRuntimeConfiguration.metadata != null) {
            result.putAll(eurekaRuntimeConfiguration.metadata);
        }
        result.putIfAbsent("context", eurekaRuntimeConfiguration.contextPath);
        return result;
    }

    public static InstanceInfoContext withConfiguration(EurekaRuntimeConfiguration eurekaRuntimeConfiguration) {
        return new DefaultInstanceInfoContext(eurekaRuntimeConfiguration);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getVipAddress() {
        return this.vipAddress;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public String getHomePageUrl() {
        return this.homePageUrl;
    }

    @Override
    public String getStatusPageUrl() {
        return this.statusPageUrl;
    }

    @Override
    public String getHealthCheckUrl() {
        return this.healthCheckUrl;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    private String buildInstanceId() {
        return String.join((CharSequence)":", this.getHostName(), this.getName(), String.valueOf(this.getPort())).toLowerCase();
    }
}

