/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka.config;

import io.quarkus.eureka.util.HostNameDiscovery;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.annotations.ConvertWith;
import java.util.Map;
import org.eclipse.microprofile.config.spi.Converter;

@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public class EurekaRuntimeConfiguration {
    @ConfigItem(defaultValue="true")
    public boolean enable;
    @ConfigItem(defaultValue="${quarkus.http.port}")
    Integer port;
    @ConfigItem(defaultValue="${quarkus.application.name}")
    String name;
    @ConfigItem(defaultValue="${quarkus.http.root-path:/}")
    String contextPath;
    @ConfigItem(defaultValue="${quarkus.application.name}")
    String vipAddress;
    @ConvertWith(value=NetworkConverter.class)
    @ConfigItem
    String hostName;
    @ConfigItem
    boolean preferIpAddress;
    @ConfigItem(defaultValue="default")
    String region;
    @ConfigItem
    Map<String, String> serviceUrl;
    @ConfigItem(defaultValue="true")
    boolean preferSameZone;
    @ConfigItem(defaultValue="/")
    String homePageUrl;
    @ConfigItem
    Map<String, String> metadata;
    @ConfigItem(defaultValue="/info/status")
    String statusPageUrl;
    @ConfigItem(defaultValue="/info/health")
    String healthCheckUrl;

    public static class NetworkConverter
    implements Converter<String> {
        private static final long serialVersionUID = -423310887944694372L;

        public String convert(String hostname) {
            if (hostname != null && !hostname.trim().isEmpty()) {
                return hostname;
            }
            return HostNameDiscovery.getHostname();
        }
    }
}

