/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka.operation.heartbeat;

import io.quarkus.eureka.client.InstanceInfo;
import io.quarkus.eureka.client.Status;
import io.quarkus.eureka.config.Location;
import io.quarkus.eureka.operation.AbstractOperation;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;

public class HeartBeatOperation
extends AbstractOperation {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void heartbeat(Location location, InstanceInfo instanceInfo) {
        String appId = instanceInfo.getApp();
        this.logger.info(String.format("%s heartbeat to %s", appId, location));
        String path = String.join((CharSequence)"/", "apps", appId, instanceInfo.getInstanceId());
        Map<String, InstanceInfo> instance = Collections.singletonMap("instance", instanceInfo.withStatus(Status.UP));
        try (Client client = ResteasyClientBuilder.newClient();){
            this.restClientBuilder(client, location, path).put(Entity.entity(instance, (MediaType)MediaType.APPLICATION_JSON_TYPE)).close();
        }
    }
}

