/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka.operation.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import io.quarkus.eureka.operation.query.InstanceResult;
import io.quarkus.eureka.operation.query.QueryResponse;
import java.util.Collections;
import java.util.List;

@JsonRootName(value="application")
@JsonIgnoreProperties(ignoreUnknown=true)
public class ApplicationResult
extends QueryResponse<ApplicationResult> {
    private final String name;
    private final List<InstanceResult> instanceResults;

    @JsonCreator
    public ApplicationResult(@JsonProperty(value="name") String name, @JsonProperty(value="instance") List<InstanceResult> instanceResults) {
        this.name = name;
        this.instanceResults = instanceResults;
    }

    public static ApplicationResult error() {
        return new ApplicationResult("", Collections.emptyList());
    }

    @Override
    public boolean success() {
        return this.instanceResults.stream().anyMatch(InstanceResult::success);
    }

    @Override
    ApplicationResult entity() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public List<InstanceResult> getInstanceResults() {
        return this.instanceResults;
    }
}

