/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka.operation.register;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.eureka.client.InstanceInfo;
import io.quarkus.eureka.client.Status;
import io.quarkus.eureka.config.Location;
import io.quarkus.eureka.operation.AbstractOperation;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;

public class RegisterOperation
extends AbstractOperation {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Location location, InstanceInfo instanceInfo) {
        String path = String.join((CharSequence)"/", "apps", instanceInfo.getApp());
        Map<String, InstanceInfo> instance = Collections.singletonMap("instance", instanceInfo.withStatus(Status.UP));
        try (Client client = ResteasyClientBuilder.newClient();){
            Response response = this.restClientBuilder(client, location, path).accept(new String[]{"application/json"}).post(Entity.entity((Object)this.objectToJson(instance), (MediaType)MediaType.APPLICATION_JSON_TYPE));
            if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                this.logger.info(String.format("Service has been registered in %s", location));
            } else if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.CLIENT_ERROR)) {
                this.logger.info(String.format("Service has problems to register in %s", location));
            } else if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SERVER_ERROR)) {
                this.logger.info(String.format("%s returns error message %s", location, response.readEntity(String.class)));
            }
            response.close();
        }
    }

    private String objectToJson(Map<String, InstanceInfo> instance) {
        try {
            return new ObjectMapper().writeValueAsString(instance);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

