/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka.registration;

import io.quarkus.eureka.client.InstanceInfo;
import io.quarkus.eureka.client.Status;
import io.quarkus.eureka.config.Location;
import io.quarkus.eureka.config.ServiceLocationConfig;
import io.quarkus.eureka.operation.OperationFactory;
import io.quarkus.eureka.operation.heartbeat.HeartBeatOperation;
import io.quarkus.eureka.operation.query.InstanceResult;
import io.quarkus.eureka.operation.query.MultipleInstanceQueryOperation;
import io.quarkus.eureka.operation.register.RegisterOperation;
import io.quarkus.eureka.registration.InstanceHealthCheckService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class EurekaRegistrationService {
    private final InstanceInfo instanceInfo;
    private final ScheduledExecutorService executorService;
    private final ServiceLocationConfig serviceLocationConfig;
    private final OperationFactory operationFactory;
    private final InstanceHealthCheckService instanceHealthCheckService;

    public EurekaRegistrationService(ServiceLocationConfig serviceLocationConfig, InstanceInfo instanceInfo, OperationFactory operationFactory) {
        this(serviceLocationConfig, instanceInfo, operationFactory, Executors.newScheduledThreadPool(3));
    }

    public EurekaRegistrationService(ServiceLocationConfig serviceLocationConfig, InstanceInfo instanceInfo, OperationFactory operationFactory, ScheduledExecutorService executorService) {
        this.instanceInfo = instanceInfo;
        this.serviceLocationConfig = serviceLocationConfig;
        this.executorService = executorService;
        this.operationFactory = operationFactory;
        this.instanceHealthCheckService = new InstanceHealthCheckService();
    }

    public void register() {
        this.serviceLocationConfig.getLocations().forEach(location -> this.executorService.scheduleWithFixedDelay(() -> ((InstanceResult)RegistrationFlow.instanceHealthCheck(() -> this.instanceHealthCheckService.healthCheck(this.instanceInfo.getHealthCheckUrl())).eurekaHealthCheck(() -> this.operationFactory.get(MultipleInstanceQueryOperation.class).findInstance((Location)location, this.instanceInfo.getApp()).getInstanceResults().stream().filter(instanceResult -> this.instanceInfo.getInstanceId().equals(instanceResult.getInstanceId())).findFirst().orElse(InstanceResult.error())).isRegistered(queryResponse -> this.operationFactory.get(HeartBeatOperation.class).heartbeat((Location)location, this.instanceInfo))).isNotRegistered(queryResponse -> this.operationFactory.get(RegisterOperation.class).register((Location)location, this.instanceInfo)), 3L, 40L, TimeUnit.SECONDS));
    }

    private static class RegistrationFlow {
        private static final Logger LOGGER = Logger.getLogger(RegistrationFlow.class.getName());
        private Status status;

        private RegistrationFlow(Status status) {
            this.status = status;
        }

        private static RegistrationFlow instanceHealthCheck(Supplier<Status> statusSupplier) {
            try {
                return new RegistrationFlow(statusSupplier.get());
            }
            catch (Exception e) {
                LOGGER.warning(e.getMessage());
                throw e;
            }
        }

        private InstanceResult eurekaHealthCheck(Supplier<InstanceResult> eurekaHealthSupplier) {
            if (Status.UP.equals((Object)this.status)) {
                return eurekaHealthSupplier.get();
            }
            return InstanceResult.error();
        }
    }
}

