/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka;

import io.quarkus.eureka.client.EurekaClient;
import io.quarkus.eureka.client.InstanceInfo;
import io.quarkus.eureka.client.loadBalancer.LoadBalanced;
import io.quarkus.eureka.client.loadBalancer.LoadBalancer;
import io.quarkus.eureka.client.loadBalancer.LoadBalancerType;
import io.quarkus.eureka.client.loadBalancer.Random;
import io.quarkus.eureka.client.loadBalancer.RoundRobin;
import io.quarkus.eureka.config.Location;
import io.quarkus.eureka.config.ServiceLocationConfig;
import io.quarkus.eureka.operation.OperationFactory;
import io.quarkus.eureka.operation.remove.RemoveInstanceOperation;
import io.quarkus.eureka.util.ServiceDiscovery;
import io.quarkus.runtime.ShutdownEvent;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.util.logging.Logger;

@ApplicationScoped
public class EurekaProducer {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private OperationFactory operationFactory;
    private InstanceInfo instanceInfo;
    private ServiceLocationConfig serviceLocationConfig;

    @Produces
    @LoadBalanced
    EurekaClient eurekaClient(InjectionPoint injectionPoint) {
        ServiceDiscovery serviceDiscovery = new ServiceDiscovery(this.serviceLocationConfig, this.operationFactory);
        LoadBalancer loadBalancer = this.selectLoadBalancer(injectionPoint, serviceDiscovery);
        return new EurekaClient(loadBalancer);
    }

    private LoadBalancer selectLoadBalancer(InjectionPoint injectionPoint, ServiceDiscovery serviceDiscovery) {
        if (((LoadBalanced)injectionPoint.getAnnotated().getAnnotation(LoadBalanced.class)).type() == LoadBalancerType.ROUND_ROBIN) {
            return new RoundRobin(serviceDiscovery);
        }
        return new Random(serviceDiscovery);
    }

    @Produces
    EurekaClient eurekaClient() {
        ServiceDiscovery serviceDiscovery = new ServiceDiscovery(this.serviceLocationConfig, this.operationFactory);
        return new EurekaClient(new Random(serviceDiscovery));
    }

    void onApplicationStop(@Observes ShutdownEvent shutdownEvent) {
        this.logger.info("application finished... now we have to deregister from Eureka...");
        String appId = this.instanceInfo.getApp();
        String instanceId = this.instanceInfo.getInstanceId();
        this.serviceLocationConfig.getLocations().forEach(location -> this.operationFactory.get(RemoveInstanceOperation.class).remove((Location)location, appId, instanceId));
    }

    void setInstanceInfo(InstanceInfo instanceInfo) {
        this.instanceInfo = instanceInfo;
    }

    void setServiceLocationConfig(ServiceLocationConfig serviceLocationConfig) {
        this.serviceLocationConfig = serviceLocationConfig;
    }

    void setOperationFactory(OperationFactory operationFactory) {
        this.operationFactory = operationFactory;
    }
}

