/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka.client;

import io.quarkus.eureka.client.loadBalancer.LoadBalancer;
import io.quarkus.eureka.exception.EurekaServiceNotFoundException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import java.util.concurrent.Executors;
import java.util.function.Supplier;

public class EurekaClient {
    private final LoadBalancer loadBalancer;
    private final Client client = ClientBuilder.newBuilder().executorService(Executors.newFixedThreadPool(50)).build();

    public EurekaClient(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public WebTarget app(String appId) {
        String target = this.loadBalancer.getHomeUrl(appId).orElseThrow(this.serviceNotFound(appId));
        return this.client.target(target);
    }

    private Supplier<EurekaServiceNotFoundException> serviceNotFound(String appId) {
        return () -> new EurekaServiceNotFoundException(appId.toUpperCase());
    }
}

