/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka.config;

import io.quarkus.eureka.config.EurekaRuntimeConfiguration;
import io.quarkus.eureka.config.Location;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ServiceLocationConfig {
    private final Collection<Location> locations;

    public ServiceLocationConfig(EurekaRuntimeConfiguration eurekaRuntimeConfiguration) {
        this(Optional.ofNullable(eurekaRuntimeConfiguration.serviceUrl).map(Map::values).orElse(Collections.emptyList()));
    }

    public ServiceLocationConfig(Collection<String> locationsAsString) {
        this.locations = locationsAsString.stream().map(Location::new).collect(Collectors.toList());
    }

    public Collection<Location> getLocations() {
        return this.locations;
    }
}

