/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka.operation;

import io.quarkus.eureka.config.Location;
import io.quarkus.eureka.operation.Operation;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.MediaType;

public abstract class AbstractOperation
implements Operation {
    protected Invocation.Builder restClientBuilder(Client client, Location location, String path) {
        Invocation.Builder builder = client.target(String.join((CharSequence)"/", location.getUrl(), path)).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        this.setAuthHeaderIfNeeded(builder, location);
        return builder;
    }

    private void setAuthHeaderIfNeeded(Invocation.Builder builder, Location location) {
        if (location.hasBasicAuthToken()) {
            builder.header("Authorization", (Object)("Basic " + location.getBasicAuthToken()));
        }
    }
}

