/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka.operation.query;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.quarkus.eureka.config.Location;
import io.quarkus.eureka.operation.AbstractOperation;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Response;
import java.io.IOException;

abstract class QueryOperation
extends AbstractOperation {
    QueryOperation() {
    }

    <T> T query(Location location, String path, Class<T> clazz) {
        Client client = ClientBuilder.newClient();
        Response response = this.restClientBuilder(client, location, path).get();
        if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            return this.onNotFound(clazz);
        }
        String json = (String)response.readEntity(String.class);
        response.close();
        client.close();
        return this.jsonToObject(clazz, json);
    }

    private <T> T jsonToObject(Class<T> clazz, String json) {
        try {
            ObjectMapper objectMapper = new ObjectMapper().enable(DeserializationFeature.UNWRAP_ROOT_VALUE).enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING).enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
            return (T)objectMapper.readerFor(clazz).readValue(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    abstract <T> T onNotFound(Class<T> var1);

    abstract <T> void onError(Class<T> var1);
}

