/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.eureka.registration;

import io.quarkus.eureka.client.InstanceInfo;
import io.quarkus.eureka.config.Location;
import io.quarkus.eureka.config.ServiceLocationConfig;
import io.quarkus.eureka.operation.OperationFactory;
import io.quarkus.eureka.registration.EurekaSingleInstanceRegister;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@FunctionalInterface
public interface EurekaInstancesRegistration {
    public void register(ScheduledExecutorService var1);

    public static EurekaInstancesRegistration createRegistration(ServiceLocationConfig serviceLocationConfig, InstanceInfo instanceInfo, OperationFactory operationFactory) {
        EurekaSingleInstanceRegister eurekaSingleInstanceRegister = new EurekaSingleInstanceRegister(instanceInfo, operationFactory);
        return executorService -> serviceLocationConfig.getLocations().forEach(location -> EurekaInstancesRegistration.registerInstance(executorService, eurekaSingleInstanceRegister, location));
    }

    private static void registerInstance(ScheduledExecutorService executorService, EurekaSingleInstanceRegister eurekaSingleInstanceRegister, Location location) {
        long initialDelay = 2L;
        long fixedDelay = 40L;
        executorService.scheduleWithFixedDelay(eurekaSingleInstanceRegister.registerLocation(location), 2L, 40L, TimeUnit.SECONDS);
    }
}

